#!/bin/bash
#---------------------------------------------------------------------------
# File: pre_check.sh
# Created Date: 2021-08-05
# Author: sunzhe
# Contact: <sunzhenet@163.com>
# 
# Last Modified: Tuesday October 24th 2023 11:13:23 am
# 
# Copyright (c) 2021 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
Current_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
# 引入基础脚本
. $Current_DIR/base_detection.sh
. $Current_DIR/install.conf

# if [ ! "$(OS_Version)" ];then
#     eval Err_Exit "非Centos7操作系统!"
# fi

if [ "$(IS_Root)" != "True" ];then
    eval Err_Exit "非root用户,请使用root用户执行脚本"
fi

if [ "$(Require_Soft "docker")" == "True" ];then
    eval Err_Exit "检测到系统已安装docker,请先卸载docker"
fi
# 检测JDK路径是否存在

if [ "$(Require_Soft "docker-compose")" == "True" ];then
    eval Err_Exit "检测到系统已安装docker-compose,请先卸载docker"
fi

if [ "$(Check_Port  "127.0.0.1" "$INSTALL_PORT")" == "True" ];then
    eval Err_Exit "检测到端口"$INSTALL_PORT"被占用,请重新选择!"
fi

# 检测CPU架构是否为x86
if [ $(uname -i) != "x86_64" ];then
    eval Err_Exit "The CPU Architecture Must Be X86"
fi

eval OS_Version
# eval Check_Disk
eval CPU_MEM
eval Success_Exit