#!/bin/bash
Current_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
# 引入基础脚本
. "$Current_DIR"/base_detection.sh
. "$Current_DIR"/install.conf
cd "$Current_DIR" || Err_Exit "进入$Current_DIR目录错误"
function InstallDocker(){
    if [ "$(Require_Soft "iptables")" != "True" ]; then
        if [ "$(Require_Soft "yum")" == "True" ]; then
            yum install iptables -y
        elif [ "$(Require_Soft "apt")" == "True" ]; then
            DEBIAN_FRONTEND=noninteractive apt install iptables -y
        else
            result=1
            Err_Exit "不支持的操作系统"
        fi
        result=$?
        if [ "$result" -ne 0 ]; then
            Err_Exit "iptables安装失败,请检查"
        fi
    fi
	
    ARCH=$(arch)
    if [ "$ARCH" = "x86_64" ]; then
    	tar -xf docker-20.10.9.tgz && cp -f docker/* /usr/bin
    	cp docker-compose /usr/bin && chmod +x /usr/bin/docker-compose
    else
    	if [ -d "arm" ]; then
	     echo "start copy arm docker..........................."
             tar -xf arm/docker-20.10.9.tgz && cp -f docker/* /usr/bin
             cp arm/docker-compose /usr/bin && chmod +x /usr/bin/docker-compose
    	else
             echo "arm 目录不存在，请检查。"
    	fi
    fi


    mkdir -p $INSTALL_DIR
    rm -rf docker
    echo "add docker link"
    ip link add name docker0 type bridge
    ip addr add 192.161.250.1/24 dev docker0
    ip link set docker0 up
    groupadd docker
    usermod -aG docker $USER
    cat > /etc/systemd/system/weaver-docker.service <<EOF
[Unit]
Description=Docker Application Container Engine
Documentation=https://docs.docker.com
After=network-online.target firewalld.service
Wants=network-online.target

[Service]
Type=notify
# the default is not to use systemd for cgroups because the delegate issues still
# exists and systemd currently does not support the cgroup feature set required
# for containers run by docker
ExecStart=/usr/bin/dockerd --selinux-enabled=false -H tcp://0.0.0.0:$INSTALL_PORT -H unix://var/run/docker.sock --data-root=$INSTALL_DIR --tls=false
ExecReload=/bin/kill -s HUP \$MAINPID
# Having non-zero Limit*s causes performance problems due to accounting overhead
# in the kernel. We recommend using cgroups to do container-local accounting.
LimitNOFILE=65535
LimitNPROC=infinity
LimitCORE=infinity
# Uncomment TasksMax if your systemd version supports it.
# Only systemd 226 and above support this version.
#TasksMax=infinity
TimeoutStartSec=0
# set delegate yes so that systemd does not reset the cgroups of docker containers
Delegate=yes
# kill only the docker process, not all processes in the cgroup
KillMode=process
# restart the docker process if it exits prematurely
Restart=on-failure
StartLimitBurst=3
StartLimitInterval=60s

[Install]
WantedBy=multi-user.target
EOF
mkdir -p /etc/docker
cat >/etc/docker/daemon.json <<EOF
{
 "registry-mirrors": ["https://registry.docker-cn.com"],
 "insecure-registries": ["192.168.7.239","reg.ecology10.cn"],
 "exec-opts": ["native.cgroupdriver=systemd"],
  "log-driver": "json-file",
  "log-opts":{
    "max-size": "100m"
   },
  "storage-driver": "overlay2",
  "bip":"192.161.250.1/24"
}
EOF
cat >$INSTALL_DIR/uninstall.sh <<EOF
  systemctl stop weaver-docker
  rm -rf $INSTALL_DIR
  rm -f /etc/systemd/system/weaver-docker.service
  rm -f /usr/bin/containerd-shim-runc-v2
  rm -f /usr/bin/dockerd
  rm -f /usr/bin/docker-proxy
  rm -f /usr/bin/ctr
  rm -f /usr/bin/docker
  rm -f /usr/bin/runc
  rm -f /usr/bin/containerd-shim
  rm -f /usr/bin/docker-init
  rm -f /usr/bin/containerd
  systemctl daemon-reload
EOF
cat >$INSTALL_DIR/start.sh <<EOF
  systemctl start weaver-docker
EOF
cat >$INSTALL_DIR/stop.sh <<EOF
  systemctl stop weaver-docker
EOF
chmod +x $INSTALL_DIR/*.sh
systemctl daemon-reload && systemctl start weaver-docker && systemctl enable weaver-docker
if [ $? -ne 0 ]; then
  eval Err_Exit "docker install error"
fi

}


docker ps > /dev/null 2>&1
status=$?

if [ $status -eq 0 ]; then
    echo "docker has install........................................."
else
    echo "start install docker......................................"
    InstallDocker
fi







docker ps > /dev/null 2>&1
status=$?

if [ $status -eq 0 ]; then
    echo "docker install success........................................."
    docker ps
else
    echo "docker install fail......................................"
    docker ps 
    exit 1
fi



chmod 777 /usr/bin/docker
chmod 777 /usr/bin/docker-compose

echo "start edit os param.................................................."

grep -q "* soft nofile 65536" /etc/security/limits.conf || echo "* soft nofile 65536" >> /etc/security/limits.conf
grep -q "* hard nofile 65536" /etc/security/limits.conf || echo "* hard nofile 65536" >> /etc/security/limits.conf
grep -q "* soft nproc 65536" /etc/security/limits.conf || echo "* soft nproc 65536" >> /etc/security/limits.conf
grep -q "* hard nproc 65536" /etc/security/limits.conf || echo "* hard nproc 65536" >> /etc/security/limits.conf
grep -q "vm.max_map_count=655360" /etc/sysctl.conf || echo "vm.max_map_count=655360" >> /etc/sysctl.conf
grep -q "vm.overcommit_memory=1" /etc/sysctl.conf || echo "vm.overcommit_memory=1" >> /etc/sysctl.conf

sysctl -p

echo "start add mq hosts................................................."

ip=$(ip -o route get to 223.5.5.5 | sed -n 's/.*src \([0-9.]\+\).*/\1/p')
# 生成主机名规则，去掉IP中的.
host_rule="dockermq${ip//./}"
# 定义要添加到 /etc/hosts文件的完整配置项
config_entry="$ip $host_rule"

# 检查 /etc/hosts文件中是否已经存在该配置项
if ! grep -q "$config_entry" /etc/hosts; then
    # 如果不存在，则添加到 /etc/hosts文件中
    echo "$config_entry" | tee -a /etc/hosts > /dev/null
    echo "已成功将 $config_entry 添加到 /etc/hosts 文件中。"
else
    # 如果已经存在，则提示用户
    echo "$config_entry 已经存在于 /etc/hosts 文件中，无需重复添加。"
fi



echo "start add user................................................."

groupadd docker
gpasswd -a $USER  docker
USER_GROUP=$(id -gn "$USER")
echo "USER_GROUP      $USER_GROUP................................................."


script_path=$(realpath "$0")

# 获取脚本所在目录
script_dir=$(dirname "$script_path")

# 获取脚本的上级目录
parent_dir=$(dirname "$script_dir")


if [ -z "$E10_INSTALL_PATH" ]; then
    E10_INSTALL_PATH="$parent_dir"
fi
echo "E10_INSTALL_PATH    $E10_INSTALL_PATH................................................."


mkdir -p $E10_INSTALL_PATH
chown -R $USER:$USER_GROUP $E10_INSTALL_PATH

if [ -z "$NFS_PATH" ]; then
    NFS_PATH="$parent_dir"
fi
echo "NFS_PATH    $NFS_PATH................................................."

mkdir -p $NFS_PATH
chown -R $USER:$USER_GROUP $NFS_PATH


if [ -z "$ROBOT_PATH" ]; then
    ROBOT_PATH="$parent_dir"
fi
echo "ROBOT_PATH    $ROBOT_PATH................................................."


mkdir -p $ROBOT_PATH
chown -R $USER:$USER_GROUP $ROBOT_PATH

yum -y install zip tar unzip net-tools


sudo -u $USER docker ps