#!/bin/bash
#---------------------------------------------------------------------------
# File: check.sh
# Created Date: 2022-07-22
# Author: sunzhe
# Contact: <sunzhenet@163.com>
# Last Modified: Saturday July 23rd 2022 11:23:06 am
# Copyright (c) 2022 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      : By:Comments
# ----------:---:----------------------------------------------------------
#---------------------------------------------------------------------------
echoError() { echo -e $"\e[43;31;5m  "$1"\e[0m"; }
for i in `cat checkurl.txt`;do
    url=$(echo $i|awk -F ":" '{print $1":"$3}')
    app_name=$(echo $i|awk -F ":" '{print $2}')
    if [ $app_name == "weaver-gateway" ] || [ $app_name == "weaver-open-gateway" ]; then
        http_code=$(curl -m 2 -sILw "%{http_code}\n" http://$url/actuator/health -o /dev/null)
    else
        http_code=$(curl -m 2 -sILw "%{http_code}\n" http://$url/remote/health.jsp -o /dev/null)
    fi
    if [[ $http_code == 200 ]]; then
        printf "%-50s  \033[32m 服务正常 \033[0m   %-20s\n" $app_name $url
        # echo $app_name "\033[32m 服务正常 \033[0m" $url
    else
        printf "%-50s  \033[31m 服务异常 \033[0m   %-20s\n" $app_name $url
        # echo -e $app_name "\033[31m 服务异常 \033[0m"  $url
    fi
    
done