#!/bin/bash
#---------------------------------------------------------------------------
# File: base_detection.sh
# Created Date: 2021-08-04
# Author: sunzhe
# Contact: <sunzhenet@163.com>
#
# Last Modified: Thursday June 23rd 2022 4:50:43 pm
#
# Copyright (c) 2021 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
export LANG=en_US.utf8
export LC_ALL=en_US.utf8
echoError() { echo -e $"\e[43;31;5m  "$1"\e[0m"; }
Current_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

function Log() {
    message="[Script Log]: $1 "
    # echo  $*
    echo -e ["$(date +%Y-%m-%d\ %H:%M:%S)"] "${message}" 2>&1 | tee -a "${Current_DIR}"/install.log
}

# 支持centos,ubuntu,suse
# function OS_Version() {
#     if [ -f /etc/redhat-release ]; then
#         echo True
#     elif [ -f /etc/os-release ];then
#         echo False
#     fi
# }

function OS_Version {
    case $(uname) in
    Linux)
        LINUX=1
        which yum 2>&1 >/dev/null && {
            echo centos
            return
        }
        which zypper 2>&1 && {
            echo opensuse
            return
        }
        which apt-get 2>&1 && {
            echo debian
            return
        }
        ;;
    Darwin)
        DARWIN=1
        Err_Exit "暂不支持DARWIN系统"
        ;;
    *)
        # Handle AmgiaOS, CPM, and modified cable modems here.
        Err_Exit "暂不支持的操作系统"
        ;;
    esac
}
function IS_Root() {
    if [ "$(id -u)" -ne 0 ]; then
        echo "False"
    else
        echo "True"
    fi
}

function Close_Selinux() {
    setenforce 0
    sed -i 's/^SELINUX=.*$/SELINUX=disabled/' /etc/selinux/config
}

function Add_Host() {
    [ "$(hostname -i | awk '{print $1}')" != "127.0.0.1" ] && sed -i "s@^127.0.0.1\(.*\)@127.0.0.1   $(hostname) \1@" /etc/hosts
}

function Change_Time() {
    rm -rf /etc/localtime
    ln -s /usr/share/zoneinfo/Asia/Shanghai /etc/localtime
    /usr/sbin/hwclock --systohc
    /usr/sbin/hwclock -w
    if which ntpdate >/dev/null; then
        /usr/sbin/ntpdate ntp.aliyun.com >/dev/null 2>&1
        cat >/var/spool/cron/root <<EOF
    10 0 * * * /usr/sbin/ntpdate ntp.aliyun.com > /dev/null 2>&1
    * * * * */1 /usr/sbin/hwclock -w > /dev/null 2>&1
EOF
    fi
}

function Limits_Config() {

    sed -i "/^ulimit -SHn.*/d" /etc/rc.d/rc.local
    echo "ulimit -SHn 1024000" >>/etc/rc.d/rc.local

    sed -i "/^ulimit -s.*/d" /etc/profile
    sed -i "/^ulimit -c.*/d" /etc/profile
    sed -i "/^ulimit -SHn.*/d" /etc/profile

    cat >>/etc/profile <<EOF
ulimit -c unlimited
ulimit -s unlimited
ulimit -SHn 1024000
EOF

    source /etc/profile
    ulimit -a
    cat /etc/profile | grep ulimit

    if [ ! -f "/etc/security/limits.conf.bak" ]; then
        cp /etc/security/limits.conf /etc/security/limits.conf.bak
    fi

    cat >/etc/security/limits.conf <<EOF
* soft nofile 1024000
* hard nofile 1024000
* soft nproc  1024000
* hard nproc  1024000
hive   - nofile 1024000
hive   - nproc  1024000
EOF

    if [ ! -f "/etc/security/limits.d/20-nproc.conf.bak" ]; then
        cp /etc/security/limits.d/20-nproc.conf /etc/security/limits.d/20-nproc.conf.bak
    fi

    cat >/etc/security/limits.d/20-nproc.conf <<EOF
*          soft    nproc     409600
root       soft    nproc     unlimited
EOF
}

LANG_config() {
    echo "LANG=\"en_US.UTF-8\"" >/etc/locale.conf
    source /etc/locale.conf
}

function Open_Port() {
    if which firewall-cmd >/dev/null; then
        if systemctl is-active firewalld &>/dev/null; then
            Log "防火墙端口开放"
            firewall-cmd --zone=public --add-port=$1/tcp --permanent
            firewall-cmd --reload
        else
            Log "防火墙未开启，忽略端口开放"
        fi
    elif which ufw >/dev/null; then
        if [ "$(ufw status | awk -F ":" '{print $2}' | tr -d " ")" == "active" ]; then
            Log "防火墙端口开放"
            ufw allow $1/tcp
        fi
    else
        Log "未找到防火墙管理软件,请手动放通端口$1"
    fi
}

function Check_Port() {
    (echo >/dev/tcp/$1/$2) &>/dev/null && echo True || echo False
}

function Check_Disk() {
    Total_Disk=$(fdisk -l | grep "Disk /dev/sd" | awk -F '[ :,]+' '{printf "%.0f\n",$5/1072741824}' | awk -v total=0 '{total+=$1}END{printf "%.0f\t",total}')
    if [ "$Total_Disk" -lt 300 ]; then
        Err_Exit "磁盘总容量小于300G,检测不通过"
    fi
    # 磁盘使用率
    Used_Disk=$(df -k | grep -v "tmpfs" | grep -E -A 1 "mapper|sd" | awk 'NF>1{print $(NF-3)}' | awk -v used=0 '{used+=$1}END{printf "%.2f\n",used/1048576}')
    # 磁盘使用率
    Disk_Usage=$(echo "$Used_Disk" "$Total_Disk" | awk '{printf ("%.2f\n",$1/$2*100)}')
    if [ "$Disk_Usage" -gt 50 ]; then
        Err_Exit "磁盘占用率超过80%,检测不通过"
    fi
}

# while [ "$1" != "" ]; do
#     case $1 in
#         -s  )   shift
# 		SERVER=$1 ;;
#         -d  )   shift
# 		DATE=$1 ;;
# 	--paramter|p ) shift
# 		PARAMETER=$1;;
#         -h|help  )   usage # function call
#                 exit ;;
#         * )     usage # All other parameters
#                 exit 1
#     esac
#     shift
# done
# sh parameter_test.sh -s myserver -d 20151225 --parameter SomeValue

function changedir() {
    DIR_NAME=$1
    # Check if the directory exist?
    [ -d "$DIR_NAME" ] || {
        echo Dir: $DIR_NAME does not exist
        exit 1
    }

    # Check if the directory is readable
    [ -r "$DIR_NAME" ] || {
        echo Dir: $DIR_NAME not readable
        exit 2
    }

    # Check if we have execute perms on directory
    [ -x "$DIR_NAME" ] || {
        echo Dir: cannot cd to $DIR_NAME
        exit 3
    }

    # Check if the directory is writable
    [ -w "$DIR_NAME" ] || {
        echo Dir: $DIR_NAME not writeable
        exit 4
    }

    cd "$DIR_NAME"
    echo "Present directory $DIR_NAME"
}

function Check_Process() {
    echo "Checking if process $1 exists..."
    [ "$1" = "" ] && return 0
    PROCESS_NUM=$(ps -ef | grep "$1" | grep -v "grep" | wc -l)
    if [ $PROCESS_NUM -ge 1 ]; then
        return 1
    else
        return 0
    fi
}

function Get_Timing() {
    start=$1
    end=$2

    start_s=$(echo $start | cut -d '.' -f 1)
    start_ns=$(echo $start | cut -d '.' -f 2)
    end_s=$(echo $end | cut -d '.' -f 1)
    end_ns=$(echo $end | cut -d '.' -f 2)

    time_micro=$(((10#$end_s - 10#$start_s) * 1000000 + (10#$end_ns / 1000 - 10#$start_ns / 1000)))
    time_ms=$(expr $time_micro/1000 | bc)

    echo "$time_ms ms"
}
function Err_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"false\",
	\"reason\":\"$1\"
}"
    exit 1
}

function Success_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"true\",
	\"reason\":\"\"
}"
    exit 0
}
function Require_Soft() {
    which $1 >/dev/null && echo "True" || echo "False"
}

# Require_Soft nginx1
# begin_time=`date +%s.%N`
# sleep 1
# end_time=`date +%s.%N`

# Get_Timing $begin_time $end_time

function Go_To() {
    label=$1
    cmd=$(sed -n "/$label:/{:a;n;p;ba};" $0 | grep -v ':$')
    eval "$cmd"
    exit
}

function Trim() {
    echo $1 | sed -r 's/^\s*(.+)\s*$/\1/'
}

function Connect_Net() {
    # 判断是否可以上网
    http_code=$(curl -sILw "%{http_code}\n" http://www.baidu.com -o /dev/null)
    if [ "$http_code" -ne 200 ]; then
        echo False
    else
        echo True
    fi
}

function CPU_MEM() {
    CPU_Cores=$(grep "processor" /proc/cpuinfo | wc -l)
    if [ "$CPU_Cores" -lt 8 ]; then
        eval Err_Exit "CPU核数过低"
    fi
    MEM_Total=$(free -m | grep Mem | awk '{print $2}')
    MEM_Swap=$(free -m | grep Swap | awk '{print $2}')
    MEM_useed=$(free -m | grep Mem | awk '{print $3}')
    MEM_UsagePercent=$(echo $MEM_useed $MEM_Total | awk '{printf ("%0.f\n",$1/$2*100)}')
    if [ "$MEM_Total" -lt 7963 ]; then
        eval Err_Exit "内存小于8G"
    elif [ "$MEM_Swap" -eq 0 ]; then
        eval Err_Exit "为配置交换内存"
    elif [ "$MEM_UsagePercent" -gt 80 ]; then
        eval Err_Exit "内存占用率超过80%"
    else
        echo "检测通过"
    fi
}

# tar cvf - mypp/log | ssh ${username}@${server} "cat > /backup/myapplog.tar"
PORT=0
function Listening {
   TCPListeningnum=$(netstat -an | grep ":$1 " | awk '$1 == "tcp" && $NF == "LISTEN" {print $0}' | wc -l)
   UDPListeningnum=$(netstat -an | grep ":$1 " | awk '$1 == "udp" && $NF == "0.0.0.0:*" {print $0}' | wc -l)
   (( Listeningnum = TCPListeningnum + UDPListeningnum ))
   if [ $Listeningnum == 0 ]; then
       echo "0"
   else
       echo "1"
   fi
}

#彌~G孾Z佌º轗´轚~O彜º录°
function random_range {
   shuf -i $1-$2 -n1
}

# 获取随机端口
function get_random_port {
   templ=0
   while [ $PORT == 0 ]; do
       temp1=$(random_range $1 $2)
       if [ "$(Listening $temp1)" == 0 ] ; then
              PORT=$temp1
       fi
   done
   echo "$PORT"
}
