#!/bin/bash
ulimit -n 65535
echo $(date "+%Y-%m-%d %H:%M:%S")"  e-monitor stopping..." >> stop.log
check_process() {
    if ps -fe | grep "e-monitor/bin" | grep "java" >/dev/null 2>&1; then
        return 0
    else
        return 1
    fi
}

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
SHUTDOWN_OUTPUT=$("$SCRIPT_DIR"/bin/shutdown.sh "$@" 2>&1)
echo "$SHUTDOWN_OUTPUT" | grep -q "Error stopping Catalina" >> stop.log
if [ $? -eq 0 ]; then
	ps -fe | grep -E "e-monitor/bin|arthas-tunnel-server-0.0.1-SNAPSHOT" | grep "java" | grep -v grep |tr -s " "|cut -d" " -f2 | xargs kill -9 >/dev/null 2>&1
    echo $(date "+%Y-%m-%d %H:%M:%S")"  e-monitor process killed.1." >> stop.log
else
	echo -n $(date "+%Y-%m-%d %H:%M:%S")"  process is stopping." >> stop.log
	for ((i=0; i<20; i++)); do
		if check_process; then
			echo -n "." >> stop.log
			sleep 1
		else
			echo "" >> stop.log
			echo $(date "+%Y-%m-%d %H:%M:%S")"  process stopped." >> stop.log
			break
		fi
	done
	if check_process; then
		ps -fe | grep -E "e-monitor/bin|arthas-tunnel-server-0.0.1-SNAPSHOT" | grep "java" | grep -v grep |tr -s " "|cut -d" " -f2 | xargs kill -9 >/dev/null 2>&1
		echo $(date "+%Y-%m-%d %H:%M:%S")"  e-monitor process killed.2." >> stop.log
	fi
fi
ps -fe | grep "arthas-tunnel-server-0.0.1-SNAPSHOT" | grep "java" | grep -v grep |tr -s " "|cut -d" " -f2 | xargs kill -9 >/dev/null 2>&1
echo $(date "+%Y-%m-%d %H:%M:%S")"  e-monitor is stopped." >> stop.log

# file_path="app/config/deploy.properties"

# 判断是否docker部署数据库
# if [ -f "$file_path" ] && grep -q "docker" "$file_path"; then
    # 执行停docker容器
#	/usr/bin/docker stop mysql >> stop.log
# fi


