#!/bin/bash
#---------------------------------------------------------------------------
# File: install.sh
# Created Date: 2021-08-11
# Author: sunzhe
# Contact: <sunzhenet@163.com>
#
# Last Modified: Tuesday October 31st 2023 7:51:57 pm
#
# Copyright (c) 2021 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
# 基础依赖包
Current_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
# 引入基础脚本
. "${Current_DIR}"/base_detection.sh
. "$Current_DIR"/install.conf
cd "$Current_DIR" || Err_Exit "进入$Current_DIR目录错误"
OLD_IFS=$IFS
IFS=","
for i in $Migrate_SVC; do
    if [ ! -d $INSTALL_DIR/$i ]; then
        eval Err_Exit "要迁移的微服务"$i"不存在,请重新输入需要迁移的服务!"
    fi
done
tar_version=$(tar --version | awk 'NR==1' | awk '{print $4}')
result=$(awk -v n1="$tar_version" -v n2="1.30" 'BEGIN { if (n1 > n2) print 1; else if (n1 < n2) print -1; else print 0 }')

IFS=$OLD_IFS
function SVC_Runing() {
    # 判断应用是否正在运行,如果正在运行需要停止
    OLD_IFS=$IFS
    IFS=","
    for i in $Migrate_SVC; do
        IS_Runing=$(ps -aux | grep java | grep $i | grep -v grep | wc -l)
        if [ $IS_Runing -gt 0 ]; then
            Log ""$i"服务正在运行,尝试停止服务"
            sh $INSTALL_DIR/$i/bin/shutdown.sh >/dev/null 2>&1
            sleep 5
            # 防止无法停止,需要kill删掉
            IS_Runing_Again=$(ps -aux | grep java | grep $i | grep -v grep | awk '{ print $2}')
            if [[ -n $IS_Runing_Again ]]; then
                kill -9 $IS_Runing_Again
            fi
        fi
    done
    IFS=$OLD_IFS
}

function Pack_SRC() {

    ReturnList=""
    OLD_IFS=$IFS
    IFS=","
    for i in $Migrate_SVC; do
        # 直接打包tomcat，不要日志
        cd $INSTALL_DIR/$i/ || Err_Exit "进入"$i"目录失败,请检查安装目录设置"
        Log "开始打包应用"
        Package_NAME="$i-$(date +%Y%m%d%H%M)-PreMigrate.tar.gz"
        if [ $result -eq 1 ]; then
            tar --exclude="*.tar.gz" --exclude="./logs" -zcf "$Package_NAME" ./*
        else
            tar -zcf "$Package_NAME" ./* --exclude="*.tar.gz" --exclude="./logs" 
        fi
        if [ $? -ne 0 ]; then
            Err_Exit "打包失败,请查看日志!"
        fi
        Log "打包成功,请传递包至目的服务器,包位置为"$INSTALL_DIR"/$i/"$Package_NAME""
        ReturnList="$ReturnList$INSTALL_DIR/$i/"$Package_NAME,""
    done
    IFS=$OLD_IFS
    # 需要返回文件路径,以,号分割
    echo $ReturnList
    eval Success_Exit "${ReturnList%?}"
}
SVC_Runing
Pack_SRC
