#!/bin/bash
#---------------------------------------------------------------------------
# File: pre_check.sh
# Created Date: 2021-08-05
# Author: sunzhe
# Contact: <sunzhenet@163.com>
#
# Last Modified: Saturday September 11th 2021 5:57:43 pm
#
# Copyright (c) 2021 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
Current_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
# 引入基础脚本
. $Current_DIR/base_detection.sh
. $Current_DIR/install.conf

# if [ ! "$(OS_Version)" ];then
#     eval Err_Exit "非Centos7操作系统!"
# fi

if [ "$(IS_Root)" != "True" ]; then
    eval Err_Exit "非root用户,请使用root用户执行脚本"
fi

# 检测目录是否存在,端口是否被占用
OLD_IFS=$IFS
IFS=","
for i in $SVC_Port; do
echo $i
    svc_dir=$(echo $i | awk -F "#######" '{print $1}')
    echo $svc_dir
    # 判断目录是否存在
    if [ -d $INSTALL_DIR/$svc_dir ]; then
        Err_Exit "服务目录"$INSTALL_DIR/$svc_dir"已存在，请重新选择安装目录"
    fi
    # 判断端口是否被占用
    svc_port=$(echo $i | awk -F "#######" '{print $2}')
    if [ "$(Check_Port "127.0.0.1" "$svc_port")" == "True" ]; then
        eval Err_Exit "检测到服务"$svc_dir"的端口"$svc_port"被占用,请重新选择端口!"
    fi
    # 判断对应的服务打包目录是否存在
    # pack_file=$(echo $i | awk -F "#######" '{print $3}')
    # echo $pack_file
    # if [ ! -f $pack_file ];then
    # eval Err_Exit "检测到服务"$svc_dir"的打包文件"$pack_file"不存在,请检查配置文件!"
    # fi
done
IFS=$OLD_IFS
if [ ! -f "$JAVA_HOME/bin/java" ]; then
    eval Err_Exit "检测到JDK路径不存在,请检查JAVA_HOME设置"
fi

# 记录第一次install.conf
echo "预检install.conf文件" >> install.log
cat $Current_DIR/install.conf >> $Current_DIR/install.log

# 检测Nacos是否可以正常连接
# NACOS_URL="http://${Nacos_ADDRESS}:${Nacos_Port}/nacos/v1/cs/configs?dataId=nacos_test&group=test&content=HelloWorld"
# # echo $NACOS_URL
# NACOS_Code=$(curl -m 2 -sILw  "%{http_code}\n" -X POST  "$NACOS_URL"  -o /dev/null)
# if [ "$NACOS_Code" -ne 200 ];then
#     Err_Exit "Nacos连接失败,请检查Nacos配置"
# fi


eval OS_Version
eval Check_Disk
eval CPU_MEM
eval Success_Exit
