#!/bin/bash
#---------------------------------------------------------------------------
# File: install.sh
# Created Date: 2021-08-09
# Author: sunzhe
# Contact: <sunzhenet@163.com>
#
# Last Modified: Tuesday April 23rd 2024 6:06:23 pm
#
# Copyright (c) 2021 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
Current_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
# 引入基础脚本
. "$Current_DIR"/base_detection.sh
. "$Current_DIR"/install.conf
cd "$Current_DIR" || Err_Exit "进入$Current_DIR目录错误"
echo "正式安装install.conf文件" >> install.log
cat $Current_DIR/install.conf >> $Current_DIR/install.log
PORT=0
function Listening {
   TCPListeningnum=$(netstat -an | grep ":$1 " | awk '$1 == "tcp" && $NF == "LISTEN" {print $0}' | wc -l)
   UDPListeningnum=$(netstat -an | grep ":$1 " | awk '$1 == "udp" && $NF == "0.0.0.0:*" {print $0}' | wc -l)
   (( Listeningnum = TCPListeningnum + UDPListeningnum ))
   if [ $Listeningnum == 0 ]; then
       echo "0"
   else
       echo "1"
   fi
}
 
#指定区间随机数
function random_range {
   shuf -i $1-$2 -n1
}
 
#得到随机端口
function get_random_port {
   templ=0
   while [ $PORT == 0 ]; do
       temp1=$(random_range $1 $2)
       if [ "$(Listening $temp1)" == 0 ] ; then
              PORT=$temp1
       fi
   done
   echo "$PORT"
}
function ADD_JAVA() {
    Default_JAVA=$(cat </etc/profile | grep -v "^#" | grep "JAVA_HOME" | grep -v "PATH" | awk -F '=' '{print $2}')
    if [ -z "$Default_JAVA" ]; then
        echo "export JAVA_HOME=$JAVA_HOME" >>/etc/profile
        echo "export PATH=\$JAVA_HOME/bin:\$PATH" >>/etc/profile
    elif [ "$Default_JAVA" != "$JAVA_HOME" ]; then
        # 删除旧有java环境变量
        sed -i '/JAVA_HOME/d' /etc/profile
        echo "export JAVA_HOME=$JAVA_HOME" >>/etc/profile
        echo "export PATH=\$JAVA_HOME/bin:\$PATH" >>/etc/profile
    fi
    source /etc/profile

}
function Install_TomCat() {

    if [ ! -d "$INSTALL_DIR" ]; then
        mkdir -p "$INSTALL_DIR"

    fi
    # 开始循环处理所需文件
    OLD_IFS=$IFS
    IFS=","
    for i in $SVC_Port; do
        echo $i
        svc_dir=$(echo $i | awk -F "#######" '{print $1}')
        # 判断目录是否存在
        if [ ! -d $INSTALL_DIR/$svc_dir ]; then
            Log "创建服务目录$svc_dir"
            mkdir -p $INSTALL_DIR/$svc_dir
        fi
        svc_port=$(echo $i | awk -F "#######" '{print $2}')
        pack_file=$(echo $i | awk -F "#######" '{print $3}')
        if [ ! -f $pack_file ]; then
            eval Err_Exit "检测到服务"$svc_dir"的打包文件"$pack_file"不存在,请检查配置文件!"
        fi
        # 开始安装tomcat
        tar -zxf "$pack_file" -C "$INSTALL_DIR/$svc_dir" | tee -a install.log
        if [ $? -ne 0 ]; then
            Err_Exit "解压"$pack_file"安装包失败,请查看日志"
        fi
        # 开始修改端口
        Log "修改服务"$svc_dir"监听端口为"$svc_port""
        begin=$(cat <"$INSTALL_DIR"/$svc_dir/bin/catalina.sh | grep -n cygwin=false | awk -F ":" '{print $1}')
        sed -i ""$begin"i\export JAVA_HOME=$JAVA_HOME" "$INSTALL_DIR"/$svc_dir/bin/catalina.sh
        #获取原始端口
        default_port=$(grep -r 'relaxedQueryChars=' "$INSTALL_DIR"/$svc_dir/conf/server.xml|grep maxPostSize |awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/port/'){ print $i }}}'|tr -cd [0-9])
        sed -i "s/"$default_port"/"$svc_port"/g" "$INSTALL_DIR"/$svc_dir/conf/server.xml 2>&1 | tee -a install.log
        if [ $? -ne 0 ]; then
            Err_Exit "修改默认端口失败,请查看日志"
        fi
        # Log "获取tomcat shutdown随机端口"
        # shutdown_port=$(get_random_port 32000 35000)
        # Log "修改服务"$svc_dir"关闭端口为"$shutdown_port""
        # Log "获取服务原始shutdown端口"
        #default_shutdown=$(cat <"$INSTALL_DIR"/$svc_dir/conf/server.xml|grep shutdown|tr -cd '[0-9]')
        #if [ ! -z "$default_shutdown" ]; then
        #sed -i "s/"$default_shutdown"/"-1"/g" "$INSTALL_DIR"/$svc_dir/conf/server.xml 2>&1 | tee -a install.log
        #fi
        Log "开始创建日志目录"
        mkdir -p "$INSTALL_DIR"/$svc_dir/logs
        touch "$INSTALL_DIR"/$svc_dir/logs/catalina.out


        Open_Port "$svc_port"
    done
    IFS=$OLD_IFS

}

ADD_JAVA
Install_TomCat

eval Success_Exit
# get_random_port 32000 35000
