CREATE TABLE "USERS"
(
 "USERNAME" VARCHAR(50) NOT NULL,
 "PASSWORD" VARCHAR(500) NOT NULL,
 "ENABLED" VARCHAR(10) NOT NULL,
 constraint USER_PK PRIMARY KEY (USERNAME)
)
/
 

CREATE TABLE "TENANT_INFO"
(
 "ID" int NOT NULL,
 "KP" VARCHAR(128) NOT NULL,
 "TENANT_DESC" VARCHAR(256) NULL,
 "CREATE_SOURCE" VARCHAR(32) NULL,
 "GMT_CREATE" VARCHAR(128)  not null,
 "GMT_MODIFIED" VARCHAR(128)  not null,
 "TENANT_NAME" VARCHAR(128) NULL,
 "TENANT_ID" VARCHAR(128) NULL,
   constraint tenant_info_id_key PRIMARY KEY (id),
  constraint uk_tenant_info_kptenantid UNIQUE (kp,tenant_id)
)
/
 
CREATE INDEX tenant_info_tenant_id_idx ON tenant_info(tenant_id)
/
 

CREATE TABLE "TENANT_CAPACITY"
(
 "ID" int NOT NULL,
 "GROUP_ID" VARCHAR(255) DEFAULT ''
 NULL,
 "TENANT_ID" VARCHAR(128) DEFAULT ''
 NOT NULL,
 "QUOTA" INT DEFAULT '0'
 NOT NULL,
 "USAGE" INT DEFAULT '0'
 NOT NULL,
 "MAX_SIZE" INT DEFAULT '0'
 NOT NULL,
 "MAX_AGGR_COUNT" INT DEFAULT '0'
 NOT NULL,
 "MAX_AGGR_SIZE" INT DEFAULT '0'
 NOT NULL,
 "MAX_HISTORY_COUNT" INT DEFAULT '0'
 NOT NULL,
 "GMT_CREATE" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
 "GMT_MODIFIED" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
   constraint tenant_capacity_id_key PRIMARY KEY (id),
  constraint uk_tenant_id UNIQUE (tenant_id)
)
/
 
CREATE TABLE "ROLES"
(
 "USERNAME" VARCHAR(50) NOT NULL,
 "ROLE" VARCHAR(50) NOT NULL,
 constraint uk_username_role UNIQUE (username,role)
)
/
 
CREATE TABLE "PERMISSIONS"
(
 "ROLE" VARCHAR(50) NOT NULL,
 "RESOURCE" VARCHAR(255) NOT NULL,
 "ACTION" VARCHAR(8) NOT NULL,
 constraint uk_role_permission UNIQUE (role,"RESOURCE",action)
)
/
 
CREATE TABLE "HIS_CONFIG_INFO"
(
 "ID" int NOT NULL,
 "NID" int NOT NULL,
 "DATA_ID" VARCHAR(255) NOT NULL,
 "GROUP_ID" VARCHAR(255) NULL,
 "CONTENT" clob NOT NULL,
 "MD5" VARCHAR(32) NULL,
 "GMT_CREATE" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
 "GMT_MODIFIED" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
 "SRC_USER" clob NULL,
 "SRC_IP" VARCHAR(50) NULL,
 "APP_NAME" VARCHAR(128) NULL,
 "TENANT_ID" VARCHAR(128) NULL,
 "OP_TYPE" CHAR(10) NULL,
 "ENCRYPTED_DATA_KEY" clob NULL,
   constraint hisconfiginfo_nid_key PRIMARY KEY (nid)
)
/
 
CREATE INDEX hisconfiginfo_dataid_key_idx ON his_config_info(data_id)
/
 
CREATE INDEX hisconfiginfo_gmt_create_idx ON his_config_info(gmt_create)
/
 
CREATE INDEX hisconfiginfo_gmt_modified_idx ON his_config_info(gmt_modified)
/
 


CREATE TABLE "GROUP_CAPACITY"
(
 "ID" int NOT NULL,
 "GROUP_ID" VARCHAR(255) DEFAULT ''
 NULL,
 "QUOTA" INT DEFAULT '0'
 NOT NULL,
 "USAGE" INT DEFAULT '0'
 NOT NULL,
 "MAX_SIZE" INT DEFAULT '0'
 NOT NULL,
 "MAX_AGGR_COUNT" INT DEFAULT '0'
 NOT NULL,
 "MAX_AGGR_SIZE" INT DEFAULT '0'
 NOT NULL,
 "MAX_HISTORY_COUNT" INT DEFAULT '0'
 NOT NULL,
 "GMT_CREATE" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
 "GMT_MODIFIED" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
   constraint group_capacity_id_key PRIMARY KEY (id),
  constraint uk_group_id UNIQUE (group_id)
)
/
 
CREATE TABLE "CONFIG_TAGS_RELATION"
(
 "ID" int NOT NULL,
 "DATA_ID" VARCHAR(255) NOT NULL,
 "GROUP_ID" VARCHAR(255) NULL,
 "TENANT_ID" VARCHAR(128) NULL,
 "NID" int NOT NULL,
 "TAG_NAME" VARCHAR(128) NOT NULL,
 "TAG_TYPE" VARCHAR(64) DEFAULT NULL
 NULL,
  constraint config_tags_id_key PRIMARY KEY (nid),
  constraint uk_configtagrelation UNIQUE (id, tag_name, tag_type)
)
/
 
CREATE TABLE "CONFIG_INFO_TAG"
(
 "ID" int NOT NULL,
 "DATA_ID" VARCHAR(255) NULL,
 "GROUP_ID" VARCHAR(255) NULL,
 "CONTENT" clob NOT NULL,
 "MD5" VARCHAR(32) NULL,
 "GMT_CREATE" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
 "GMT_MODIFIED" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
 "SRC_USER" clob NULL,
 "SRC_IP" VARCHAR(50) NULL,
 "APP_NAME" VARCHAR(128) NULL,
 "TENANT_ID" VARCHAR(128) NULL,
 "TAG_ID" VARCHAR(128) NULL,
   constraint configinfotag_id_key PRIMARY KEY (id),
  constraint uk_configinfotag  UNIQUE (data_id,group_id,tenant_id,tag_id)
)
/
 
CREATE TABLE "CONFIG_INFO_BETA"
(
 "ID" int NOT NULL,
 "DATA_ID" VARCHAR(255) NOT NULL,
 "GROUP_ID" VARCHAR(255) NULL,
 "CONTENT" clob NOT NULL,
 "MD5" VARCHAR(32) NULL,
 "GMT_CREATE" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
 "GMT_MODIFIED" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
 "SRC_USER" clob NULL,
 "SRC_IP" VARCHAR(50) NULL,
 "APP_NAME" VARCHAR(128) NULL,
 "TENANT_ID" VARCHAR(128) NULL,
 "BETA_IPS" VARCHAR(1024) DEFAULT NULL,
 "ENCRYPTED_DATA_KEY" clob NULL,
  constraint configinfobeta_id_key PRIMARY KEY (id),
  constraint uk_configinfobeta UNIQUE (data_id,group_id,tenant_id)
)
/
 
CREATE TABLE "CONFIG_INFO_AGGR"
(
 "ID" int NOT NULL,
 "DATA_ID" VARCHAR(255) NOT NULL,
 "GROUP_ID" VARCHAR(255) NOT NULL,
 "DATUM_ID" VARCHAR(255) NOT NULL,
 "CONTENT" clob NOT NULL,
 "GMT_MODIFIED" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
 "APP_NAME" VARCHAR(128) DEFAULT NULL
 NULL,
 "TENANT_ID" VARCHAR(128) DEFAULT ''
 NULL,
 constraint configinfoaggr_id_key PRIMARY KEY (id),
  constraint uk_configinfoaggr UNIQUE (data_id,group_id,tenant_id,datum_id)
)
/
 
CREATE TABLE "CONFIG_INFO"
(
 "ID" int NOT NULL,
 "DATA_ID" VARCHAR(255) NOT NULL,
 "GROUP_ID" VARCHAR(255) NULL,
 "CONTENT" clob NOT NULL,
 "MD5" VARCHAR(32) NULL,
 "GMT_CREATE" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
 "GMT_MODIFIED" timestamp DEFAULT to_timestamp('2021-01-01 11:11:11','yyyy-mm-dd hh24:mi:ss')  not null,
 "SRC_USER" clob NULL,
 "SRC_IP" VARCHAR(50) NULL,
 "APP_NAME" VARCHAR(128) NULL,
 "TENANT_ID" VARCHAR(128)  DEFAULT '',
 "C_DESC" VARCHAR(256) NULL,
 "C_USE" VARCHAR(64) NULL,
 "EFFECT" VARCHAR(64) NULL,
 "TYPE" VARCHAR(64) NULL,
 "C_SCHEMA" clob NULL,
 "ENCRYPTED_DATA_KEY" clob NULL,
   constraint configinfo_id_key PRIMARY KEY (id),
  constraint uk_configinfo  UNIQUE (data_id,group_id,tenant_id)
)
/
 
CREATE INDEX configinfo_dataid_key_idx ON config_info(data_id)
/
 
CREATE INDEX configinfo_groupid_key_idx ON config_info(group_id)
/
 
CREATE INDEX configinfo_dataid ON config_info(data_id, group_id)
/
 



INSERT INTO "ROLES"("USERNAME","ROLE") VALUES('nacos','ROLE_ADMIN')
/
 

INSERT INTO "USERS"("USERNAME","PASSWORD","ENABLED") VALUES('nacos','$2a$10$4wUAmSxbxG0Au38T1ZDL0.Lwn1Y/bUWuAP3P3Bx5bcpnhwN3RSizy','1')
/
 

COMMENT ON TABLE "TENANT_INFO" IS 'tenant_info'
/
 
COMMENT ON COLUMN "TENANT_INFO"."ID" IS 'id'
/
 
COMMENT ON COLUMN "TENANT_INFO"."KP" IS 'kp'
/
 
COMMENT ON COLUMN "TENANT_INFO"."TENANT_DESC" IS 'tenant_desc'
/
 
COMMENT ON COLUMN "TENANT_INFO"."CREATE_SOURCE" IS 'create_source'
/
 
COMMENT ON COLUMN "TENANT_INFO"."GMT_CREATE" IS '创建时间'
/
 
COMMENT ON COLUMN "TENANT_INFO"."GMT_MODIFIED" IS '修改时间'
/
 
COMMENT ON COLUMN "TENANT_INFO"."TENANT_NAME" IS 'tenant_name'
/
 
COMMENT ON COLUMN "TENANT_INFO"."TENANT_ID" IS 'tenant_id'
/
 
COMMENT ON TABLE "TENANT_CAPACITY" IS '租户容量信息表'
/
 
COMMENT ON COLUMN "TENANT_CAPACITY"."ID" IS '主键ID'
/
 
COMMENT ON COLUMN "TENANT_CAPACITY"."GROUP_ID" IS 'Group ID，空字符表示整个集群'
/
 
COMMENT ON COLUMN "TENANT_CAPACITY"."TENANT_ID" IS 'Tenant ID'
/
 
COMMENT ON COLUMN "TENANT_CAPACITY"."QUOTA" IS '配额，0表示使用默认值'
/
 
COMMENT ON COLUMN "TENANT_CAPACITY"."USAGE" IS '使用量'
/
 
COMMENT ON COLUMN "TENANT_CAPACITY"."MAX_SIZE" IS '单个配置大小上限，单位为字节，0表示使用默认值'
/
 
COMMENT ON COLUMN "TENANT_CAPACITY"."MAX_AGGR_COUNT" IS '聚合子配置最大个数，，0表示使用默认值'
/
 
COMMENT ON COLUMN "TENANT_CAPACITY"."MAX_AGGR_SIZE" IS '单个聚合数据的子配置大小上限，单位为字节，0表示使用默认值'
/
 
COMMENT ON COLUMN "TENANT_CAPACITY"."MAX_HISTORY_COUNT" IS '最大变更历史数量'
/
 
COMMENT ON COLUMN "TENANT_CAPACITY"."GMT_CREATE" IS '创建时间'
/
 
COMMENT ON COLUMN "TENANT_CAPACITY"."GMT_MODIFIED" IS '修改时间'
/
 

COMMENT ON TABLE "HIS_CONFIG_INFO" IS '多租户改造'
/
 
COMMENT ON COLUMN "HIS_CONFIG_INFO"."APP_NAME" IS 'app_name'
/
 
COMMENT ON COLUMN "HIS_CONFIG_INFO"."TENANT_ID" IS '租户字段'
/
 
COMMENT ON TABLE "GROUP_CAPACITY" IS '集群、各Group容量信息表'
/
 
COMMENT ON COLUMN "GROUP_CAPACITY"."ID" IS '主键ID'
/
 
COMMENT ON COLUMN "GROUP_CAPACITY"."GROUP_ID" IS 'Group ID，空字符表示整个集群'
/
 
COMMENT ON COLUMN "GROUP_CAPACITY"."QUOTA" IS '配额，0表示使用默认值'
/
 
COMMENT ON COLUMN "GROUP_CAPACITY"."USAGE" IS '使用量'
/
 
COMMENT ON COLUMN "GROUP_CAPACITY"."MAX_SIZE" IS '单个配置大小上限，单位为字节，0表示使用默认值'
/
 
COMMENT ON COLUMN "GROUP_CAPACITY"."MAX_AGGR_COUNT" IS '聚合子配置最大个数，，0表示使用默认值'
/
 
COMMENT ON COLUMN "GROUP_CAPACITY"."MAX_AGGR_SIZE" IS '单个聚合数据的子配置大小上限，单位为字节，0表示使用默认值'
/
 
COMMENT ON COLUMN "GROUP_CAPACITY"."MAX_HISTORY_COUNT" IS '最大变更历史数量'
/
 
COMMENT ON COLUMN "GROUP_CAPACITY"."GMT_CREATE" IS '创建时间'
/
 
COMMENT ON COLUMN "GROUP_CAPACITY"."GMT_MODIFIED" IS '修改时间'
/
 

COMMENT ON TABLE "CONFIG_TAGS_RELATION" IS 'config_tags_relation'
/
 
COMMENT ON COLUMN "CONFIG_TAGS_RELATION"."ID" IS 'id'
/
 
COMMENT ON COLUMN "CONFIG_TAGS_RELATION"."DATA_ID" IS 'data_id'
/
 
COMMENT ON COLUMN "CONFIG_TAGS_RELATION"."GROUP_ID" IS 'group_id'
/
 
COMMENT ON COLUMN "CONFIG_TAGS_RELATION"."TENANT_ID" IS 'tenant_id'
/
 
COMMENT ON COLUMN "CONFIG_TAGS_RELATION"."TAG_NAME" IS 'tag_name'
/
 
COMMENT ON COLUMN "CONFIG_TAGS_RELATION"."TAG_TYPE" IS 'tag_type'
/
 
COMMENT ON TABLE "CONFIG_INFO_TAG" IS 'config_info_tag'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."ID" IS 'id'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."DATA_ID" IS 'data_id'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."GROUP_ID" IS 'group_id'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."CONTENT" IS 'content'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."MD5" IS 'md5'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."GMT_CREATE" IS '创建时间'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."GMT_MODIFIED" IS '修改时间'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."SRC_USER" IS 'source_user'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."SRC_IP" IS 'source_ip'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."APP_NAME" IS 'app_name'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."TENANT_ID" IS '租户字段'
/
 
COMMENT ON COLUMN "CONFIG_INFO_TAG"."TAG_ID" IS 'tag_id'
/
 
COMMENT ON TABLE "CONFIG_INFO_BETA" IS 'config_info_beta'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."ID" IS 'id'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."DATA_ID" IS 'data_id'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."GROUP_ID" IS 'group_id'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."CONTENT" IS 'content'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."MD5" IS 'md5'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."GMT_CREATE" IS '创建时间'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."GMT_MODIFIED" IS '修改时间'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."SRC_USER" IS 'source_user'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."SRC_IP" IS 'source_ip'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."APP_NAME" IS 'app_name'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."TENANT_ID" IS '租户字段'
/
 
COMMENT ON COLUMN "CONFIG_INFO_BETA"."BETA_IPS" IS 'betaIps'
/
 
COMMENT ON TABLE "CONFIG_INFO_AGGR" IS '增加租户字段'
/
 
COMMENT ON COLUMN "CONFIG_INFO_AGGR"."ID" IS 'id'
/
 
COMMENT ON COLUMN "CONFIG_INFO_AGGR"."DATA_ID" IS 'data_id'
/
 
COMMENT ON COLUMN "CONFIG_INFO_AGGR"."GROUP_ID" IS 'group_id'
/
 
COMMENT ON COLUMN "CONFIG_INFO_AGGR"."DATUM_ID" IS 'datum_id'
/
 
COMMENT ON COLUMN "CONFIG_INFO_AGGR"."CONTENT" IS '内容'
/
 
COMMENT ON COLUMN "CONFIG_INFO_AGGR"."GMT_MODIFIED" IS '修改时间'
/
 
COMMENT ON COLUMN "CONFIG_INFO_AGGR"."TENANT_ID" IS '租户字段'
/
 
COMMENT ON TABLE "CONFIG_INFO" IS 'config_info'
/
 
COMMENT ON COLUMN "CONFIG_INFO"."ID" IS 'id'
/
 
COMMENT ON COLUMN "CONFIG_INFO"."DATA_ID" IS 'data_id'
/
 
COMMENT ON COLUMN "CONFIG_INFO"."GROUP_ID" IS 'group_id'
/
 
COMMENT ON COLUMN "CONFIG_INFO"."CONTENT" IS 'content'
/
 
COMMENT ON COLUMN "CONFIG_INFO"."MD5" IS 'md5'
/
 
COMMENT ON COLUMN "CONFIG_INFO"."GMT_CREATE" IS '创建时间'
/
 
COMMENT ON COLUMN "CONFIG_INFO"."GMT_MODIFIED" IS '修改时间'
/
 
COMMENT ON COLUMN "CONFIG_INFO"."SRC_USER" IS 'source_user'
/
 
COMMENT ON COLUMN "CONFIG_INFO"."SRC_IP" IS 'source_ip'
/
 
COMMENT ON COLUMN "CONFIG_INFO"."APP_NAME" IS 'app_name'
/
 
COMMENT ON COLUMN "CONFIG_INFO"."TENANT_ID" IS '租户字段'
/
 


CREATE SEQUENCE "CONFIG_INFO_AGGR_SEQ" INCREMENT BY 1 START WITH 1 MAXVALUE 9223372036854775807 MINVALUE 1
/
 
CREATE SEQUENCE "CONFIG_INFO_BETA_SEQ" INCREMENT BY 1 START WITH 1 MAXVALUE 9223372036854775807 MINVALUE 1
/
 
CREATE SEQUENCE "CONFIG_INFO_SEQ" INCREMENT BY 1 START WITH 1 MAXVALUE 9223372036854775807 MINVALUE 1
/
 
CREATE SEQUENCE "CONFIG_INFO_TAG_SEQ" INCREMENT BY 1 START WITH 1 MAXVALUE 9223372036854775807 MINVALUE 1
/
 
CREATE SEQUENCE "CONFIG_TAGS_RELATION_SEQ" INCREMENT BY 1 START WITH 1 MAXVALUE 9223372036854775807 MINVALUE 1
/
 
CREATE SEQUENCE "GROUP_CAPACITY_SEQ" INCREMENT BY 1 START WITH 1 MAXVALUE 9223372036854775807 MINVALUE 1
/ 
CREATE SEQUENCE "HIS_CONFIG_INFO_SEQ" INCREMENT BY 1 START WITH 1 MAXVALUE 9223372036854775807 MINVALUE 1
/
 
CREATE SEQUENCE "TENANT_CAPACITY_SEQ" INCREMENT BY 1 START WITH 1 MAXVALUE 9223372036854775807 MINVALUE 1
/
 
CREATE SEQUENCE "TENANT_INFO_SEQ" INCREMENT BY 1 START WITH 1 MAXVALUE 9223372036854775807 MINVALUE 1
/
 
CREATE OR REPLACE TRIGGER config_info_aggr_TRI BEFORE
        INSERT
                ON config_info_aggr  for each row begin
        select config_info_aggr_SEQ.nextval into :new.id from dual;
end;
 /

CREATE OR REPLACE TRIGGER config_info_beta_TRI BEFORE
        INSERT
                ON config_info_beta  for each row begin
        select config_info_beta_SEQ.nextval into :new.id from dual;
end;
 /
CREATE OR REPLACE TRIGGER config_info_tag_TRI BEFORE
        INSERT
                ON config_info_tag  for each row begin
        select config_info_tag_SEQ.nextval into :new.id from dual;
end;
/
 
CREATE OR REPLACE TRIGGER config_info_TRI BEFORE
        INSERT
                ON config_info  for each row begin
        select config_info_SEQ.nextval into :new.id from dual;
end;
/
 
CREATE OR REPLACE TRIGGER config_tags_relation_TRI BEFORE
        INSERT
                ON config_tags_relation  for each row begin
        select config_tags_relation_SEQ.nextval into :new.nid from dual;
end;
 /
CREATE OR REPLACE TRIGGER group_capacity_TRI BEFORE
        INSERT
                ON group_capacity  for each row begin
        select group_capacity_SEQ.nextval into :new.id from dual;
end;
 /
CREATE OR REPLACE TRIGGER his_config_info_TRI BEFORE
        INSERT
                ON his_config_info  for each row begin
        select his_config_info_SEQ.nextval into :new.nid from dual;
end;
 /
CREATE OR REPLACE TRIGGER tenant_capacity_TRI BEFORE
        INSERT
                ON tenant_capacity  for each row begin
        select tenant_capacity_SEQ.nextval into :new.id from dual;
end;
/ 
CREATE OR REPLACE TRIGGER tenant_info_TRI BEFORE
        INSERT
                ON tenant_info  for each row begin
        select tenant_info_SEQ.nextval into :new.id from dual;
end;
 /




