IF
	EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[config_info]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[config_info] 
GO
	CREATE TABLE [config_info] (
		[id] bigint NOT NULL,
		[data_id] nvarchar ( 255 ) NOT NULL,
		[group_id] nvarchar ( 255 ) NULL,
		[content] nvarchar ( MAX ) NOT NULL,
		[md5] nvarchar ( 32 ) NULL,
		[gmt_create] datetime2 ( 0 ) NOT NULL,
		[gmt_modified] datetime2 ( 0 ) NOT NULL,
		[src_user] nvarchar ( MAX ) NULL,
		[src_ip] nvarchar ( 50 ) NULL,
		[app_name] nvarchar ( 128 ) NULL,
		[tenant_id] nvarchar ( 128 ) NULL,
		[c_desc] nvarchar ( 256 ) NULL,
		[c_use] nvarchar ( 64 ) NULL,
		[effect] nvarchar ( 64 ) NULL,
		[type] nvarchar ( 64 ) NULL,
		[c_schema] nvarchar ( MAX ) NULL 
	) 
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
			ALTER TABLE dbo.config_info ADD CONSTRAINT PK_config_info PRIMARY KEY CLUSTERED ( id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			CREATE NONCLUSTERED INDEX uk_configinfo_datagrouptenant ON dbo.config_info ( data_id,group_id,tenant_id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			ALTER TABLE dbo.config_info 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT

-- 此表数据大小做了改变 data_id datum_id
IF EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[config_info_aggr]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[config_info_aggr] 
GO
	CREATE TABLE [config_info_aggr] (
		[id] bigint NOT NULL,
		[data_id] nvarchar ( 230 ) NOT NULL,
		[group_id] nvarchar ( 255 ) NOT NULL,
		[datum_id] nvarchar ( 230 ) NOT NULL,
		[content] nvarchar ( MAX ) NOT NULL,
		[gmt_modified] datetime2 ( 0 ) NOT NULL,
		[app_name] nvarchar ( 128 ) NULL,
		[tenant_id] nvarchar ( 128 ) NULL 
	) 
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
			ALTER TABLE dbo.config_info_aggr ADD CONSTRAINT PK_config_info_aggr PRIMARY KEY CLUSTERED ( id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			CREATE NONCLUSTERED INDEX uk_configinfoaggr_datagrouptenantdatum ON dbo.config_info_aggr ( data_id,group_id,tenant_id,datum_id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			ALTER TABLE dbo.config_info_aggr 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT


IF EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[config_info_beta]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[config_info_beta] 
GO
	CREATE TABLE [config_info_beta] (
		[id] bigint NOT NULL,
		[data_id] nvarchar ( 255 ) NOT NULL,
		[group_id] nvarchar ( 128 ) NOT NULL,
		[app_name] nvarchar ( 128 ) NULL,
		[content] nvarchar ( MAX ) NOT NULL,
		[beta_ips] nvarchar ( 1024 ) NULL,
		[md5] nvarchar ( 32 ) NULL,
		[gmt_create] datetime2 ( 0 ) NOT NULL,
		[gmt_modified] datetime2 ( 0 ) NOT NULL,
		[src_user] nvarchar ( MAX ) NULL,
		[src_ip] nvarchar ( 50 ) NULL,
		[tenant_id] nvarchar ( 128 ) NULL 
	) 
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
			ALTER TABLE dbo.config_info_beta ADD CONSTRAINT PK_config_info_beta PRIMARY KEY CLUSTERED ( id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			CREATE NONCLUSTERED INDEX uk_configinfobeta_datagrouptenant ON dbo.config_info_beta ( data_id,group_id,tenant_id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			ALTER TABLE dbo.config_info_beta 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT


IF EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[config_info_tag]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[config_info_tag] 
GO
	CREATE TABLE [config_info_tag] (
		[id] bigint NOT NULL,
		[data_id] nvarchar ( 255 ) NOT NULL,
		[group_id] nvarchar ( 128 ) NOT NULL,
		[tenant_id] nvarchar ( 128 ) NULL,
		[tag_id] nvarchar ( 128 ) NOT NULL,
		[app_name] nvarchar ( 128 ) NULL,
		[content] nvarchar ( MAX ) NOT NULL,
		[md5] nvarchar ( 32 ) NULL,
		[gmt_create] datetime2 ( 0 ) NOT NULL,
		[gmt_modified] datetime2 ( 0 ) NOT NULL,
		[src_user] nvarchar ( MAX ) NULL,
		[src_ip] nvarchar ( 50 ) NULL 
	) 
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
			ALTER TABLE dbo.config_info_tag ADD CONSTRAINT PK_config_info_tag PRIMARY KEY CLUSTERED ( id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			CREATE NONCLUSTERED INDEX uk_configinfotag_datagrouptenanttag ON dbo.config_info_tag ( data_id,group_id,tenant_id,tag_id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			ALTER TABLE dbo.config_info_tag 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT

-- 需要配置外键与 tenant_info 表
IF EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[config_tags_relation]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[config_tags_relation] 
GO
	CREATE TABLE [config_tags_relation] (
		[id] bigint NOT NULL,
		[tag_name] nvarchar ( 128 ) NOT NULL,
		[tag_type] nvarchar ( 64 ) NULL,
		[data_id] nvarchar ( 255 ) NOT NULL,
		[group_id] nvarchar ( 128 ) NOT NULL,
		[tenant_id] nvarchar ( 128 ) NULL,
		[nid] bigint NOT NULL 
	) 
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
			ALTER TABLE dbo.config_tags_relation ADD CONSTRAINT PK_config_tags_relation PRIMARY KEY CLUSTERED ( nid ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			CREATE NONCLUSTERED INDEX uk_configtagrelation_configidtag ON dbo.config_tags_relation ( id,tag_name,tag_type ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			ALTER TABLE dbo.config_tags_relation 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT


IF EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[group_capacity]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[group_capacity] 
GO
	CREATE TABLE [group_capacity] (
		[id] bigint NOT NULL,
		[group_id] nvarchar ( 128 ) NOT NULL,
		[quota] INT NOT NULL,
		[usage] INT NOT NULL,
		[max_size] INT NOT NULL,
		[max_aggr_count] INT NOT NULL,
		[max_aggr_size] INT NOT NULL,
		[max_history_count] INT NOT NULL,
		[gmt_create] datetime2 ( 0 ) NOT NULL,
		[gmt_modified] datetime2 ( 0 ) NOT NULL 
	) 
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
			ALTER TABLE dbo.group_capacity ADD CONSTRAINT PK_group_capacity PRIMARY KEY CLUSTERED ( id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			CREATE NONCLUSTERED INDEX uk_group_id ON dbo.group_capacity ( group_id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			ALTER TABLE dbo.config_tags_relation 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT

-- 缺失外键
IF EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[his_config_info]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[his_config_info] 
GO
	CREATE TABLE [his_config_info] (
		[id] bigint NOT NULL,
		[nid] bigint NOT NULL,
		[data_id] nvarchar ( 255 ) NOT NULL,
		[group_id] nvarchar ( 128 ) NOT NULL,
		[app_name] nvarchar ( 128 ) NULL,
		[content] nvarchar ( MAX ) NOT NULL,
		[md5] nvarchar ( 32 ) NULL,
		[gmt_create] datetime2 ( 0 ) NOT NULL,
		[gmt_modified] datetime2 ( 0 ) NOT NULL,
		[src_user] nvarchar ( MAX ) NULL,
		[src_ip] nvarchar ( 50 ) NULL,
		[op_type] NCHAR ( 10 ) NULL,
		[tenant_id] nvarchar ( 128 ) NULL 
	) 
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
			ALTER TABLE dbo.his_config_info ADD CONSTRAINT PK_his_config_info PRIMARY KEY CLUSTERED ( nid ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			ALTER TABLE dbo.his_config_info 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT


IF EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[tenant_capacity]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[tenant_capacity] 
GO

	CREATE TABLE [tenant_capacity] (
		[id] bigint NOT NULL,
		[tenant_id] nvarchar(128) NOT NULL,
		[quota] int NOT NULL,
		[usage] int NOT NULL,
		[max_size] int NOT NULL,
		[max_aggr_count] int NOT NULL,
		[max_aggr_size] int NOT NULL,
		[max_history_count] int NOT NULL,
		[gmt_create] datetime2(0) NOT NULL,
		[gmt_modified] datetime2(0) NOT NULL
)
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
			ALTER TABLE dbo.tenant_capacity ADD CONSTRAINT PK_tenant_capacity PRIMARY KEY CLUSTERED ( id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			CREATE NONCLUSTERED INDEX uk_tenant_id ON dbo.tenant_capacity ( tenant_id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			ALTER TABLE dbo.tenant_capacity 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT


-- 缺失外键
IF EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[tenant_info]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[tenant_info] 
GO
	CREATE TABLE [tenant_info] (
		[id] bigint NOT NULL,
		[kp] nvarchar ( 128 ) NOT NULL,
		[tenant_id] nvarchar ( 128 ) NULL,
		[tenant_name] nvarchar ( 128 ) NULL,
		[tenant_desc] nvarchar ( 256 ) NULL,
		[create_source] nvarchar ( 32 ) NULL,
		[gmt_create] bigint NOT NULL,
		[gmt_modified] bigint NOT NULL 
	) 
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
			ALTER TABLE dbo.tenant_info ADD CONSTRAINT PK_tenant_info PRIMARY KEY CLUSTERED ( id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			CREATE NONCLUSTERED INDEX uk_tenant_info_kptenantid ON dbo.tenant_info ( kp, tenant_id ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			ALTER TABLE dbo.tenant_info 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT


IF EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[users]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[users] 
GO
	CREATE TABLE [users] ( [username] nvarchar ( 50 ) NOT NULL, [password] nvarchar ( 500 ) NOT NULL, [enabled] tinyint NOT NULL ) 
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
		DECLARE
			@v sql_variant 
			SET @v = N'True--1，False--0' EXECUTE sp_addextendedproperty N'MS_Description', @v,
			N'SCHEMA',
			N'dbo',
			N'TABLE',
			N'users',
			N'COLUMN',
			N'enabled' 
		GO
			ALTER TABLE dbo.users 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT


IF
	EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[roles]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[roles] 
GO
	CREATE TABLE [roles] ( [username] nvarchar ( 50 ) NOT NULL, [role] nvarchar ( 50 ) NOT NULL ) 
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
			CREATE NONCLUSTERED INDEX idx_user_role ON dbo.roles ( username, role ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			ALTER TABLE dbo.roles 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT


IF EXISTS ( SELECT * FROM sys.all_objects WHERE object_id = OBJECT_ID( N'[nacos_config].[dbo].[permissions]' ) AND type IN ( 'U' ) ) DROP TABLE [nacos_config].[dbo].[permissions] 
GO
	CREATE TABLE [permissions] ( [role] nvarchar ( 50 ) NOT NULL, [resource] nvarchar ( 255 ) NOT NULL, [action] nvarchar ( 8 ) NOT NULL, ) 
GO
BEGIN TRANSACTION 
		SET QUOTED_IDENTIFIER ON 
		SET ARITHABORT ON 
		SET NUMERIC_ROUNDABORT OFF 
		SET CONCAT_NULL_YIELDS_NULL ON 
		SET ANSI_NULLS ON 
		SET ANSI_PADDING ON 
		SET ANSI_WARNINGS ON COMMIT BEGIN TRANSACTION 
		GO
			CREATE NONCLUSTERED INDEX uk_role_permission ON dbo.permissions ( role, resource, ACTION ) WITH ( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY] 
		GO
			ALTER TABLE dbo.permissions 
			SET ( LOCK_ESCALATION = TABLE ) 
	GO
COMMIT



INSERT INTO [dbo].[users] ( [username], [password], [enabled] )
VALUES
	( 'nacos', '$2a$10$EuWPZHzz32dJN7jexM34MOeYirDdFAZm2kuWj7VEOJhhZkDrxfvUu', 1 ) 
GO


INSERT INTO [dbo].[roles] ( [username], [role] )
VALUES
	( 'nacos', 'ROLE_ADMIN' ) 
GO
