#! /bin/bash
# 禁用IPV6

export LANG=en_US.utf8
export LC_ALL=en_US.utf8
echoError() { echo -e $"\e[43;31;5m  "$1"\e[0m"; }
Current_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

ip=$(ip -o route get to 223.5.5.5 | sed -n 's/.*src \([0-9.]\+\).*/\1/p')
function Log() {
    message="[Script Log]: $1 "
    # echo  $*
    echo -e ["$(date +%Y-%m-%d\ %H:%M:%S)"] "${message}" 2>&1 | tee -a "${Current_DIR}"/install.log
}

function IS_Root() {
    if [ "$(id -u)" -ne 0 ]; then
        echo "False"
    else
        echo "True"
    fi
}
function Err_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"false\",
	\"reason\":\"$1\"
}"
    exit 1
}

function Success_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"true\",
	\"reason\":\""$1"\"
}"
    exit 0
}
function Require_Soft() {
    which $1 >/dev/null && echo "True" || echo "False"
}

function main() {
    if [ "$(IS_Root)" != "True" ]; then
        eval Err_Exit "非root用户,不允许安装,请联系架构部李斌!"
    fi
    echo "net.ipv6.conf.all.disable_ipv6 = 1" >>/etc/sysctl.conf
    if grep -q "nameserver .*:[0-9a-fA-F]" /etc/resolv.conf; then
        Log "IPv6 addresses found in /etc/resolv.conf"

        # Remove IPv6 addresses from lines
        sed -i.bak -E '/nameserver .*:[0-9a-fA-F]/d' /etc/resolv.conf
        ping -c 1 223.5.5.5 >/dev/null
        if [ $? -eq 0 ]; then
            if grep -q "223.5.5.5" /etc/resolv.conf; then
                echo "skip"
            else
                echo "nameserver 223.5.5.5 " >>/etc/resolv.conf
                
            fi
        fi
        Log "IPv6 addresses removed"
    else
        Log "No IPv6 addresses found in /etc/resolv.conf"
    fi
    Success_Exit
}
main
