#!/bin/bash
export LANG=en_US.utf8
export LC_ALL=en_US.utf8
echoError() { echo -e $"\e[43;31;5m  "$1"\e[0m"; }
Current_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
JAVA_HOME=$Current_DIR/jdk
ip=$(ip -o route get to 223.5.5.5 | sed -n 's/.*src \([0-9.]\+\).*/\1/p')

function Log() {
    message="[Script Log]: $1 "
    # echo  $*
    echo -e ["$(date +%Y-%m-%d\ %H:%M:%S)"] "${message}" 2>&1 | tee -a "${Current_DIR}"/install.log
}
function Require_Soft() {
    which $1 >/dev/null && echo "True" || echo "False"
}
function Open_Port() {
    if which firewall-cmd >/dev/null; then
        if systemctl is-active firewalld &>/dev/null; then
            Log "防火墙端口开放"
            firewall-cmd --zone=public --add-port=$1/tcp --permanent
            firewall-cmd --reload
        else
            Log "防火墙未开启，忽略端口开放"
        fi
    elif which ufw >/dev/null; then
        if [ "$(ufw status | awk -F ":" '{print $2}' | tr -d " ")" == "active" ]; then
            Log "防火墙端口开放"
            ufw allow $1/tcp
        fi
    else
        Log "未找到防火墙管理软件,请手动放通端口$1"
    fi
}
function IS_Root() {
    if [ "$(id -u)" -ne 0 ]; then
        echo "False"
    else
        echo "True"
    fi
}

function Err_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"false\",
	\"reason\":\"$1\"
}"
    exit 1
}

function Success_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"true\",
	\"reason\":\""$1"\"
}"
    exit 0
}

function installDocker() {
    mv -f $1/docker $1/docker-bak 
    tar -xf docker-20.10.9.tgz 2>/dev/null && mv -f $1/docker/* /usr/bin >/dev/null 2>&1
    groupadd docker >/dev/null 2>&1
    usermod -aG docker $USER >/dev/null 2>&1
    cat >/etc/systemd/system/weaver-docker.service <<EOF
[Unit]
Description=Docker Application Container Engine
Documentation=https://docs.docker.com
After=network-online.target firewalld.service
Wants=network-online.target

[Service]
Type=notify
# the default is not to use systemd for cgroups because the delegate issues still
# exists and systemd currently does not support the cgroup feature set required
# for containers run by docker
ExecStart=/usr/bin/dockerd --selinux-enabled=false  -H unix://var/run/docker.sock --data-root=$1/docker --tls=false
ExecReload=/bin/kill -s HUP \$MAINPID
# Having non-zero Limit*s causes performance problems due to accounting overhead
# in the kernel. We recommend using cgroups to do container-local accounting.
LimitNOFILE=infinity
LimitNPROC=infinity
LimitCORE=infinity
# Uncomment TasksMax if your systemd version supports it.
# Only systemd 226 and above support this version.
#TasksMax=infinity
TimeoutStartSec=0
# set delegate yes so that systemd does not reset the cgroups of docker containers
Delegate=yes
# kill only the docker process, not all processes in the cgroup
KillMode=process
# restart the docker process if it exits prematurely
Restart=on-failure
StartLimitBurst=3
StartLimitInterval=60s

[Install]
WantedBy=multi-user.target
EOF

    cat >/etc/docker/daemon.json <<EOF
{
 "registry-mirrors": ["https://registry.docker-cn.com"],
 "insecure-registries": ["192.168.7.239","reg.ecology10.cn"],
 "exec-opts": ["native.cgroupdriver=systemd"],
  "log-driver": "json-file",
  "log-opts":{
    "max-size": "100m"
   },
  "storage-driver": "overlay2",
  "bip":"192.161.250.1/24"
}
EOF
    cat >$1/docker/uninstall.sh <<EOF
  systemctl stop weaver-docker
  rm -rf $1/docker
  rm -f /etc/systemd/system/weaver-docker.service
  rm -f /usr/bin/containerd-shim-runc-v2
  rm -f /usr/bin/dockerd
  rm -f /usr/bin/docker-proxy
  rm -f /usr/bin/ctr
  rm -f /usr/bin/docker
  rm -f /usr/bin/runc
  rm -f /usr/bin/containerd-shim
  rm -f /usr/bin/docker-init
  rm -f /usr/bin/containerd
  systemctl daemon-reload
EOF
    cat >$1/docker/start.sh <<EOF
  systemctl start weaver-docker
EOF
    cat >$1/docker/stop.sh <<EOF
  systemctl stop weaver-docker
EOF
    chmod +x $1/docker/*.sh
    systemctl daemon-reload && systemctl restart weaver-docker && systemctl enable weaver-docker
    if [ $? -ne 0 ]; then
        eval Err_Exit "docker install error"
    fi

}
function Check_Port() {
    (echo >/dev/tcp/$1/$2) &>/dev/null && echo True || echo False
}

function main() {

    # 检测基本文件是否存在，包括montir3.zip 和 mysql.tar.gz
    if [ ! -d $Current_DIR/mydata ] || [ ! -f $Current_DIR/mysql8.tar ]  || [ ! -f $Current_DIR/docker-20.10.9.tgz ] || [ ! -f $Current_DIR/curlie ]; then
        eval Err_Exit "检测到"$Current_DIR"目录下,没有mysql数据文件夹mydata 或mysql8.tar文件， 或docker-20.10.9.tgz文件，请检查"
    fi
    for i in 9081 3308 40003; do
        # echo  $(Check_Port 0.0.0.0 $i)
        if [ $(Check_Port 0.0.0.0 $i) == "True" ]; then
            echo "$i端口已被占用,请解除占用后重新安装!"
            exit 1
        fi
    done
    # 安装docker
    installDocker $Current_DIR
    docker load < mysql8.tar
    docker run --name  mysql -d -p 3308:3308 -v ${Current_DIR}/mydata:/opt/mysql/mydata -v ${Current_DIR}/mylog:/opt/mysql/mylog reg.e-cology.cn/e10/e10-mysql:v2

    sleep 5
    echo -ne '\n' | echo "  "
    process_num=$(ps -ef | grep mysqld | grep -v grep | grep 3308 | wc -l)
    if [ $process_num -ne 0 ]; then
   
        Open_Port 9081
        Open_Port 40003
        # 修改catalina中JAVA_HOME
        old_javahome=$(cat $Current_DIR/bin/catalina.sh |grep JAVA_HOME=|grep jdk|grep -v '^#'|awk -F "=" '{print $2}')
        sed -i "s|$old_javahome|$Current_DIR/jdk|g" $Current_DIR/bin/catalina.sh
        begin=$(cat <${Current_DIR}/bin/catalina.sh | grep -n cygwin=false | awk -F ":" '{print $1}')
        sed -i ""$begin"i\CATALINA_HOME=${Current_DIR}" "$Current_DIR"/bin/catalina.sh
        # 修改catalina中JAVA_HOME
        chmod -R 775 ${Current_DIR}/
        
        
        cd ${Current_DIR}/bin && bash startup.sh 2>&1 | tee -a "${Current_DIR}"/install.log
        # 生成启动脚本

        cat >${Current_DIR}/start_all.sh <<EOF
#!/bin/bash
ulimit -n 65535
cd ${Current_DIR} && /usr/bin/docker restart mysql && bash bin/startup.sh
EOF
        cat >${Current_DIR}/stop_all.sh <<EOF
#!/bin/bash
ulimit -n 65535
cd ${Current_DIR} && /usr/bin/docker stop mysql && ps -fe | grep "e-monitor" | grep "java" | grep -v grep |tr -s " "|cut -d" " -f2 | xargs kill -9 >/dev/null 2>&1
EOF
        cat >${Current_DIR}/uninstall.sh <<EOF
#!/bin/bash
ulimit -n 65535
cd ${Current_DIR} && /usr/bin/docker rm -f mysql && ps -fe | grep "e-monitor" | grep "java" | grep -v grep |tr -s " "|cut -d" " -f2 | xargs kill -9 >/dev/null 2>&1
EOF
        chmod -R 775 ${Current_DIR}/*.sh
        Log "配置开机自启"
        if [ $(grep "${Current_DIR}/start_all.sh" /etc/crontab | wc -l) -le 0 ]; then
            echo "@reboot root ${Current_DIR}/start_all.sh" >>/etc/crontab
        fi

        Log "开始启动运维平台,成功后会自动打印访问信息,请勿退出该进程"
        while true; do
            response=$(${Current_DIR}/curlie --connect-timeout 10 -m 20 -s "127.0.0.1:9081/monitor/health" 2>&1 )
            if echo "$response" | grep -q "success"; then
                echo "启动运维平台并解析E10服务安装包成功,请用以下信息登录运维平台继续安装E10"
                break
            else
                sleep 5
            fi
        done

        # 获取账号密码
        # 打印临时密码
        echo ""
        echo ""
        echo "E10系统（含运维平台）总安装目录：${Current_DIR}"
        echo "运维平台访问地址：http://$ip:9081"
        echo "运维平台初始账号: admin"
        echo "运维平台初始密码: admin"
        echo "如果疑问，请联系李斌（上海）或陈进!"
        echo ""
        echo ""
        echo ""
        # 生成安装路径与服务名称
        echo "e-monitor: ${Current_DIR}" >>/tmp/.weaverinstall


    else
        eval Err_Exit "MySQL安装失败,退出安装!"
    fi

}

main "$@"
