#!/bin/bash
export LANG=en_US.utf8
export LC_ALL=en_US.utf8
echoError() { echo -e $"\e[43;31;5m  "$1"\e[0m"; }
Current_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
JAVA_HOME=$Current_DIR/jdk

function Log() {
    message="[Script Log]: $1 "
    # echo  $*
    echo -e ["$(date +%Y-%m-%d\ %H:%M:%S)"] "${message}" 2>&1 | tee -a "${Current_DIR}"/install.log
}
function Require_Soft() {
    which $1 >/dev/null && echo "True" || echo "False"
}
function Open_Port() {
    if which firewall-cmd >/dev/null; then
        if systemctl is-active firewalld &>/dev/null; then
            Log "防火墙端口开放"
            firewall-cmd --zone=public --add-port=$1/tcp --permanent
            firewall-cmd --reload
        else
            Log "防火墙未开启，忽略端口开放"
        fi
    elif which ufw >/dev/null; then
        if [ "$(ufw status | awk -F ":" '{print $2}' | tr -d " ")" == "active" ]; then
            Log "防火墙端口开放"
            ufw allow $1/tcp
        fi
    else
        Log "未找到防火墙管理软件,请手动放通端口$1"
    fi
}
function IS_Root() {
    if [ "$(id -u)" -ne 0 ]; then
        echo "False"
    else
        echo "True"
    fi
}

function Err_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"false\",
	\"reason\":\"$1\"
}"
    exit 1
}

function Success_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"true\",
	\"reason\":\""$1"\"
}"
    exit 0
}
function CheckYum() {
    if [ "$(IS_Root)" != "True" ]; then
        eval Err_Exit "非root用户,无法检测yum源或apt源"
    fi
    timeoutVersion=$(/usr/bin/timeout --version|awk 'NR==1{print}'|tr -cd 0-9)
    if [ $timeoutVersion -lt 822 ]; then
        command="/usr/bin/timeout  180"
    else
        command="/usr/bin/timeout -k 10 180"
    fi
    if [ "$(Require_Soft "yum")" == "True" ]; then
        # 代表是centos系列 yum运行30s,30s未终止,将在10s内强制杀死
        packeageManage="yum"
        packageName="libaio numactl unzip"
      
    elif [ "$(Require_Soft "apt")" == "True" ]; then
       packeageManage="apt"
       packageName="numactl unzip"
       apt install -y $(apt-cache search --names-only '^libaio[0-9]*' | awk '{print $1}') 2>&1 > /dev/null
    else
        result=1
        Err_Exit "不支持的操作系统"
    fi
    $command $packeageManage install $packageName -y
    result=$?
    if [ "$result" -ne 0 ]; then
        Err_Exit "Install MySQL Dependence libaio,numactl Error"
    fi

}
function main() {
    #    if [ "$(IS_Root)" != "True" ]; then
    #        eval Err_Exit "非root用户,请使用root用户执行脚本"
    #    fi
    CheckYum


    # 检测基本文件是否存在，包括montir3.zip 和 weaver_mysql.tar.gz
    if [ ! -d $Current_DIR/mydata ]; then
        eval Err_Exit "检测到"$Current_DIR"目录下,没有mysql数据文件夹mydata，请检查"
    fi
    # 检测端口是否被占用
    # if [ "$(Check_Port "127.0.0.1" "9081")" == "True" ]; then
    #     eval Err_Exit "检测到端口9081被占用,请重新选择端口!"
    # fi
    ps -ef | grep mysqld | grep e-monitor | grep -v grep | grep 3308 | awk '{print $2}' | xargs kill -9 >/dev/null 2>&1
    ps -ef | grep e-monitor | grep -v grep | grep jdk | awk '{print $2}' | xargs kill -9 >/dev/null 2>&1
    ps -ef | grep e-monitor-robot | grep -v grep | awk '{print $2}' | xargs kill -9 >/dev/null 2>&1


    chmod -R 755 $Current_DIR/bin $Current_DIR/*.sh $Current_DIR/mysql/base/bin/
    groupadd mysql
    useradd -r -g mysql mysql

    chown -R mysql:mysql $Current_DIR/mysql
    chown -R mysql:mysql $Current_DIR/mylog
    chown -R mysql:mysql $Current_DIR/mydata

    #sed -i "s/SOURCEDBIP/$sourcedbip/g" `grep SOURCEDBIP -rl ./conf.json.bak`

    srcdir_name=$(grep basedir $Current_DIR/mydata/3308/my.cnf|awk '{print $3}'|awk -F"/mysql" '{print $1}')
    #echo $p1

    sed -i "s|$srcdir_name|$Current_DIR|g" $Current_DIR/mydata/3308/my.cnf
    #sed -i "s/30000/900000/g" `grep 30000 -rl $1/mydata/3308/my.cnf `

    #mv ./conf.json ./conf.json.old
    #mv ./conf.json.bak ./conf.json

    $Current_DIR/mysql/base/bin/mysqld_safe --defaults-file=$Current_DIR/mydata/3308/my.cnf &

    sleep 5
    echo -ne '\n' | echo "  "
    process_num=$(ps -ef | grep mysqld | grep -v grep | grep 3308 | wc -l)
    if [ $process_num -ne 0 ]; then
        # mysql 安装成功，开始初始化e-monitor
        if [ -f $Current_DIR/install.log ]; then
            rm -rf $Current_DIR/install.log
            if [ $? -ne 0 ]; then
                eval Err_Exit "删除install.log失败"
            fi
        fi
        Open_Port 9081
        Open_Port 40003

        # 修改catalina中JAVA_HOME
        old_javahome=$(cat $Current_DIR/bin/catalina.sh |grep JAVA_HOME=|grep jdk|grep -v '^#'|awk -F "=" '{print $2}')
        sed -i "s|$old_javahome|$Current_DIR/jdk|g" $Current_DIR/bin/catalina.sh
        Success_Exit "修改完成"

    else
        eval Err_Exit "MySQL安装失败,退出安装!"
    fi

}

main "$@"
