#!/bin/bash

# 定义配置文件路径
sshdpath="/etc/ssh/sshd_config"
backup_path="/etc/ssh/sshd_config_origin"

# 检查备份文件是否存在，若不存在则进行备份
if [ ! -f "$backup_path" ]; then
    cp "$sshdpath" "$backup_path"
    echo "备份 $sshdpath 到 $backup_path"
fi


# 读取文件内容到数组
lines=()
while IFS= read -r line; do
    lines+=("$line")
done < "$sshdpath"

# 用于标记是否需要修改文件
need_update=false

# 遍历每一行
for i in "${!lines[@]}"; do
    line="${lines[$i]}"
    if [[ $line == *"GSSAPIAuthentication"* && ($line == *"yes"* || $line == *"no"*) ]]; then
        lines[$i]="GSSAPIAuthentication no"
        echo "fix GSSAPIAuthentication"
        need_update=true
    elif [[ $line == *"PasswordAuthentication"* && ($line == *"yes"* || $line == *"no"*) ]]; then
        lines[$i]="PasswordAuthentication yes"
        echo "fix PasswordAuthentication"
        need_update=true
    elif [[ $line == *"PermitRootLogin"* && ($line == *"yes"* || $line == *"no"*) ]]; then
        lines[$i]="PermitRootLogin yes"
        echo "fix PermitRootLogin"
        need_update=true
    elif [[ $line == *"HostKeyAlgorithms"* ]]; then
      # 先处理去掉注释的情况
        if [[ $line == "#"* ]]; then
            line="${line/#\#HostKeyAlgorithms/HostKeyAlgorithms}"
            echo "fix HostKeyAlgorithms"
            need_update=true
        fi
        # 再处理添加 ssh-rsa 的情况
        if [[ $line != *"ssh-rsa"* ]]; then
            line="${line/HostKeyAlgorithms /HostKeyAlgorithms ssh-rsa,}"
            echo "fix HostKeyAlgorithms ssh-rsa"
            need_update=true
        fi
        # 更新数组中的行
        lines[$i]="$line"
    elif [[ $line == *"Subsystem"* && $line == *"sftp"* && $line == *"sftp-server"* ]]; then
        if [[ $line == "#"* ]]; then
            lines[$i]="${line/#\#Subsystem/Subsystem}"
            echo "fix Subsystem"
            need_update=true
        fi
    fi
done

# 如果需要更新文件，则写入修改后的内容
if $need_update; then
    printf "%s\n" "${lines[@]}" > "$sshdpath"
fi

# 重启 sshd 服务
command_output=$(systemctl restart sshd 2>&1)
if [ $? -ne 0 ]; then
    echo "Error executing command: $command_output"
else
    echo "sshd service restarted successfully"
fi
