#!/bin/bash
#示例:app/cmd/./restore_tables.sh 3308 root mima weaverops server_info,machine_info,server_machine mybak mysql/base/bin/mysql
# 获取参数
DB_PORT="$1"
DB_USER="$2"
DB_PASS="$3"
DB_NAME="$4"
TABLES="$5"
BACKUP_DIR="$6"
MYSQL_CMD="$7"

# 将传入的表名以逗号分隔成数组
IFS=',' read -ra TABLES <<< "$TABLES"

# 原始表重命名
for TABLE_NAME in "${TABLES[@]}"
do
  # 获取备份文件
  LATEST_BACKUP=$(ls -t ${BACKUP_DIR}/${DB_NAME}_${TABLE_NAME}_*.sql 2>/dev/null | head -n1)

  # 如果没有备份文件，则打印错误消息并退出
  if [ -z "${LATEST_BACKUP}" ]; then
    echo "No backup file found for table ${TABLE_NAME}."
    exit 1
  fi

  # 重命名原始表
  RENAMED_TABLE="${TABLE_NAME}_$(date +%Y%m%d_%H%M%S)"
  "${MYSQL_CMD}" -h 127.0.0.1 -P${DB_PORT} -u ${DB_USER} -p${DB_PASS} -e "RENAME TABLE ${DB_NAME}.${TABLE_NAME} TO ${DB_NAME}.${RENAMED_TABLE}"

done


# 还原备份文件到原始表
for TABLE_NAME in "${TABLES[@]}"
do
  # 获取备份文件
  LATEST_BACKUP=$(ls -t ${BACKUP_DIR}/${DB_NAME}_${TABLE_NAME}_*.sql 2>/dev/null | head -n1)
  
  # 检查 GTID_PURGED 和 GTID_EXECUTED 是否相同
  PURGED=$("${MYSQL_CMD}" -h 127.0.0.1 -P${DB_PORT} -u ${DB_USER} -p${DB_PASS} -e "SELECT @@GLOBAL.GTID_PURGED")
  EXECUTED=$("${MYSQL_CMD}" -h 127.0.0.1 -P${DB_PORT} -u ${DB_USER} -p${DB_PASS} -e "SELECT @@GLOBAL.GTID_EXECUTED")

  if [ "${PURGED}" != "${EXECUTED}" ]; then
    # echo "GTID_PURGED (${PURGED}) and GTID_EXECUTED (${EXECUTED}) are not the same. Clearing GTID_PURGED..."
    "${MYSQL_CMD}" -h 127.0.0.1 -P${DB_PORT} -u ${DB_USER} -p${DB_PASS} -e "RESET MASTER"
  fi

  "${MYSQL_CMD}" -h 127.0.0.1 -P${DB_PORT} -u ${DB_USER} -p${DB_PASS} -D ${DB_NAME} < ${LATEST_BACKUP}

  # 打印成功消息
  echo "Table ${TABLE_NAME} has been restored from ${LATEST_BACKUP}."
done

