#!/bin/bash
#---------------------------------------------------------------------------
# File: clear_index_fores.sh
# Created Date: 2022-06-30
# Author: sunzhe
# Contact: <sunzhenet@163.com>
# Last Modified: Tuesday August 30th 2022 4:30:01 pm
# Copyright (c) 2022 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
#!/bin/bash
######################################################
# $Name:        clean_es_index.sh
# $Version:     v1.0
# $Function:    clean es log index
# $Author:      sjt
# $Create Date: 2018-05-14
# $Description: shell
######################################################
#本文未加文件锁，需要的可以加
#脚本的日志文件路径
function Err_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"false\",
	\"reason\":\"$1\"
}"
    exit 1
}

function Success_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"true\",
	\"reason\":\"\"
}"
    exit 0
}
CLEAN_LOG="clean_es_index.log"

#elasticsearch 的主机ip及端口
SERVER_PORT=$1
#删除多少天以前的日志，假设输入10，意味着10天前的日志都将会被删除
DELTIME=$2
USER_PASS=$3
#取出已有的索引信息
http_code=$(curl -m 60 ${USER_PASS}  -XGET -sILw "%{http_code}\n" "${SERVER_PORT}/_cat/indices?v" -o /dev/null)
if [[ $http_code != 200 ]]; then
    Err_Exit "ES Connect Error,Please Check config!"
fi
function deleteIndex() {

    INDEXS=$(curl -s ${USER_PASS} "${SERVER_PORT}/_cat/indices?v" | grep "$1" | awk '{print $3}')

    # seconds since 1970-01-01 00:00:00 seconds
    SECONDS=$(date -d "$(date +%F) -${DELTIME} days" +%s)
    #判断日志文件是否存在，不存在需要创建。
    if [ ! -f "${CLEAN_LOG}" ]; then
        touch "${CLEAN_LOG}"
    fi
    #删除指定日期索引
    echo "----------------------------clean time is $(date +%Y-%m-%d_%H:%M:%S) ------------------------------" >>${CLEAN_LOG}
    for del_index in ${INDEXS}; do
        # 改进日期提取逻辑，支持带后缀的日期格式（如2025.12.11-09）
        # 提取格式为 数字.数字.数字(-数字) 的日期部分
        indexDate=$(echo "${del_index}" | grep -oE '[0-9]+\.[0-9]+\.[0-9]+(-[0-9]+)?' | head -1)
        
        if [ -z "${indexDate}" ]; then
            echo "Skip index ${del_index} (no valid date found)" >>${CLEAN_LOG}
            continue
        fi

        # 将日期格式中的点替换为横杠（2025.12.11-09 → 2025-12-11-09）
        format_date=$(echo "${indexDate}" | sed 's/\./-/g')
        echo "Processing index ${del_index}, date part: ${format_date}" >>${CLEAN_LOG}
        
        # 验证日期格式有效性（只取年月日部分验证）
        date_only=$(echo "${format_date}" | cut -d'-' -f1-3)
        if ! date -d "${date_only}" +%s >/dev/null 2>&1; then
            echo "Invalid date format in index ${del_index} (${date_only})" >>${CLEAN_LOG}
            continue
        fi

        # 使用年月日部分计算时间戳
        indexSecond=$(date -d "${date_only}" +%s)
        if [ $(($SECONDS - $indexSecond)) -gt 0 ]; then
            echo "${del_index}" | tee -a ${CLEAN_LOG}
            #取出删除索引的返回结果
            delResult=$(curl -s ${USER_PASS} -XDELETE "${SERVER_PORT}/${del_index}?pretty" | sed -n '2p')
            #写入日志
            echo "clean time is $(date)" >>${CLEAN_LOG}
            echo "delResult is ${delResult}" >>${CLEAN_LOG}
        fi
    done

}

function deleteIndexTomcat() {
    INDEX_PREFIX="filebeat-tomcat"
    INDEXS=$(curl -s ${USER_PASS} "${SERVER_PORT}/_cat/indices?v" | grep "$INDEX_PREFIX" | awk '{print $3}')

    # seconds since 1970-01-01 00:00:00 seconds
    SECONDS=$(date -d "$(date +%F) -${DELTIME} days" +%s)
    #判断日志文件是否存在，不存在需要创建。
    if [ ! -f "${CLEAN_LOG}" ]; then
        touch "${CLEAN_LOG}"
    fi
    #删除指定日期索引
    echo "----------------------------clean time is $(date +%Y-%m-%d_%H:%M:%S) ------------------------------" >>${CLEAN_LOG}
    for del_index in ${INDEXS}; do
        # 复用改进后的日期提取逻辑
        indexDate=$(echo "${del_index}" | grep -oE '[0-9]+\.[0-9]+\.[0-9]+(-[0-9]+)?' | head -1)
        
        if [ -z "${indexDate}" ]; then
            echo "Skip index ${del_index} (no valid date found)" >>${CLEAN_LOG}
            continue
        fi

        format_date=$(echo "${indexDate}" | sed 's/\./-/g')
        echo "Processing index ${del_index}, date part: ${format_date}" >>${CLEAN_LOG}
        
        date_only=$(echo "${format_date}" | cut -d'-' -f1-3)
        if ! date -d "${date_only}" +%s >/dev/null 2>&1; then
            echo "Invalid date format in index ${del_index} (${date_only})" >>${CLEAN_LOG}
            continue
        fi

        indexSecond=$(date -d "${date_only}" +%s)
        if [ $(($SECONDS - $indexSecond)) -gt 0 ]; then
            echo "${del_index}" | tee -a ${CLEAN_LOG}
            delResult=$(curl -s ${USER_PASS} -XDELETE "${SERVER_PORT}/${del_index}?pretty" | sed -n '2p')
            echo "clean time is $(date)" >>${CLEAN_LOG}
            echo "delResult is ${delResult}" >>${CLEAN_LOG}
        fi
    done

}
# 支持包括 filebeat-sys-redis-2025.12.11-09 在内的多种格式
deleteIndex "filebeat-sys"
deleteIndex "filebeat-tomcat"
# 如需单独指定redis前缀可以添加：
# deleteIndex "filebeat-sys-redis"

Success_Exit