#!/bin/bash
#示例:app/cmd/./backup_tables.sh 3308 root mima weaverops server_info,machine_info,server_machine mybak mysql/base/bin/mysqldump
# 获取参数
DB_PORT="$1"
DB_USER="$2"
DB_PASS="$3"
DB_NAME="$4"
TABLES="$5"
BACKUP_DIR="$6"
MYSQL_CMD="$7"

# 如果传入的备份路径不存在则创建
if [ ! -d "$BACKUP_DIR" ]; then
  mkdir -p "$BACKUP_DIR"
fi

# 将传入的表名以逗号分隔成数组
IFS=',' read -ra TABLES <<< "$TABLES"

# 遍历表并进行备份
for TABLE_NAME in "${TABLES[@]}"
do
  # 拼接备份文件名
  BACKUP_FILE="${BACKUP_DIR}/${DB_NAME}_${TABLE_NAME}_$(date +%Y%m%d_%H%M%S).sql"

  # 备份表
  "${MYSQL_CMD}" -h 127.0.0.1 -P${DB_PORT} -u ${DB_USER} -p${DB_PASS} ${DB_NAME} ${TABLE_NAME} > ${BACKUP_FILE}

  # 打印成功消息
  echo "Table ${TABLE_NAME} has been backed up to ${BACKUP_FILE}."
done

