#!/bin/bash
#---------------------------------------------------------------------------
# File: CheckYum.sh
# Created Date: 2022-04-01
# Author: sunzhe
# Contact: <sunzhenet@163.com>
# Last Modified: Thursday January 12th 2023 5:08:33 pm
# Copyright (c) 2022 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
export LANG=en_US.utf8
export LC_ALL=en_US.utf8
# 检测yum源需要root权限
function IS_Root() {
    if [ "$(id -u)" -ne 0 ]; then
        echo "False"
    else
        echo "True"
    fi
}
function Err_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"false\",
	\"reason\":\"$1\"
}"
    exit 1
}

function Success_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"true\",
	\"reason\":\"\"
}"
    exit 0
}
function Require_Soft() {
    which $1 >/dev/null && echo "True" || echo "False"
}

function CheckYum() {
    if [ "$(IS_Root)" != "True" ]; then
        eval Err_Exit "非root用户,无法检测yum源或apt源"
    fi
    # 修改系统打开文件数
    echo "* soft nofile 65535" >> /etc/security/limits.conf
    echo "* hard nofile 65535" >> /etc/security/limits.conf
    timeoutVersion=$(/usr/bin/timeout --version|awk 'NR==1{print}'|tr -cd 0-9)
    if [ $timeoutVersion -lt 822 ]; then
        command="/usr/bin/timeout  180"
    else
        command="/usr/bin/timeout -k 10 180"
    fi
    if [ "$(Require_Soft "yum")" == "True" ]; then
        # 代表是centos系列 yum运行30s,30s未终止,将在10s内强制杀死
        packeageManage="yum"
        packageName="unzip net-tools  nfs-utils"
      
    elif [ "$(Require_Soft "apt")" == "True" ]; then
       packeageManage="apt"
       packageName="unzip net-tools  nfs-common"
    else
        result=1
        Err_Exit "不支持的操作系统"
    fi
    $command $packeageManage install $packageName -y
    result=$?
    if [ "$result" -ne 0 ]; then
        Err_Exit "yum源或apt源检测失败,请检查"
    fi

}
CheckYum
Success_Exit
