#!/bin/bash
#---------------------------------------------------------------------------
# File: CheckOS.sh
# Created Date: 2022-04-01
# Author: sunzhe
# Contact: <sunzhenet@163.com>
# Last Modified: Wednesday July 12th 2023 9:43:31 am
# Copyright (c) 2022 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
# 检测系统版本
export LANG=en_US.utf8
export LC_ALL=en_US.utf8
function Err_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"false\",
	\"reason\":\"$1\"
}"
    exit 1
}

function Success_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"true\",
	\"reason\":\"\"
}"
    exit 0
}
function detect_os() {
    if [[ (-z "${os}") && (-z "${dist}") ]]; then
        if [ -e /etc/os-release ]; then
            . /etc/os-release
            os=${ID}
            if [ "${os}" = "poky" ]; then
                dist=$(echo ${VERSION_ID})
            elif [ "${os}" = "sles" ]; then
                dist=$(echo ${VERSION_ID})
            elif [ "${os}" = "opensuse" ]; then
                dist=$(echo ${VERSION_ID})
            elif [ "${os}" = "opensuse-leap" ]; then
                os=opensuse
                dist=$(echo ${VERSION_ID})
            else
                dist=$(echo ${VERSION_ID} | awk -F '.' '{ print $1 }')
            fi

        elif [ $(which lsb_release 2>/dev/null) ]; then
            # get major version (e.g. '5' or '6')
            dist=$(lsb_release -r | cut -f2 | awk -F '.' '{ print $1 }')

            # get os (e.g. 'centos', 'redhatenterpriseserver', etc)
            os=$(lsb_release -i | cut -f2 | awk '{ print tolower($1) }')

        elif [ -e /etc/oracle-release ]; then
            dist=$(cut -f5 --delimiter=' ' /etc/oracle-release | awk -F '.' '{ print $1 }')
            os='ol'

        elif [ -e /etc/fedora-release ]; then
            dist=$(cut -f3 --delimiter=' ' /etc/fedora-release)
            os='fedora'

        elif [ -e /etc/redhat-release ]; then
            os_hint=$(cat /etc/redhat-release | awk '{ print tolower($1) }')
            if [ "${os_hint}" = "centos" ]; then
                dist=$(cat /etc/redhat-release | awk '{ print $3 }' | awk -F '.' '{ print $1 }')
                os='centos'
            elif [ "${os_hint}" = "scientific" ]; then
                dist=$(cat /etc/redhat-release | awk '{ print $4 }' | awk -F '.' '{ print $1 }')
                os='scientific'
            else
                dist=$(cat /etc/redhat-release | awk '{ print tolower($7) }' | cut -f1 --delimiter='.')
                os='redhatenterpriseserver'
            fi

        else
            aws=$(grep -q Amazon /etc/issue)
            if [ "$?" = "0" ]; then
                dist='6'
                os='aws'
            else
                unknown_os
            fi
        fi
    fi

    if [[ (-z "${os}") || (-z "${dist}") ]]; then
        unknown_os
    fi

    # remove whitespace from OS and dist name
    os="${os// /}"
    dist="${dist// /}"

    echo "${os}/${dist}"

    if [ "${dist}" = "8" ]; then
        _skip_pygpgme=1
    else
        _skip_pygpgme=0
    fi
}
os_list="centos/7 centos/8 rhel/7 rhel/8 ubuntu/20 ubuntu/21 ubuntu/22"
if [[ "${os_list[*]}" =~ $(detect_os) ]]; then
    echo "版本检测通过"
else
    Err_Exit "当前系统版本暂不支持,支持的系统版本为"$os_list""
fi

Success_Exit