#!/bin/bash
#---------------------------------------------------------------------------
# File: CheckFirewall.sh
# Created Date: 2022-04-01
# Author: sunzhe
# Contact: <sunzhenet@163.com>
# Last Modified: Sunday September 1st 2024 9:53:04 am
# Copyright (c) 2022 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
# 检查防火墙
export LANG=en_US.utf8
export LC_ALL=en_US.utf8
function Close_Selinux() {
    setenforce 0
    sed -i 's/^SELINUX=.*$/SELINUX=disabled/' /etc/selinux/config
}

update_hosts_file() {
    # 获取主机名
    local hostname=$(hostname)

    # 如果主机名是localhost，则不做任何操作
    if [ "$hostname" == "localhost" ]; then
        echo "Hostname is localhost, no changes made."
        return 0
    fi

    # 获取当前IP地址
    local ip_address=$(ip -o route get to 223.5.5.5 | sed -n 's/.*src \([0-9.]\+\).*/\1/p')

    # Host配置文件路径
    local hosts_file="/etc/hosts"

    # 检查并删除127.0.0.1的主机配置
    

    # 检查是否已经存在相同的IP和主机名的记录
    if ! grep -q "$ip_address\s\+$hostname" $hosts_file; then
        # 如果不存在，添加新记录
        sed -i "/127.0.0.1\s\+$hostname/d" $hosts_file
        echo "$ip_address $hostname" >> $hosts_file
        echo "Added $ip_address $hostname to $hosts_file"
    else
        echo "$ip_address $hostname already exists in $hosts_file"
    fi
}
function Change_Time() {
    rm -rf /etc/localtime
    ln -s /usr/share/zoneinfo/Asia/Shanghai /etc/localtime
    /usr/sbin/hwclock --systohc
    /usr/sbin/hwclock -w
#     if which ntpdate >/dev/null; then
#         /usr/sbin/ntpdate ntp.aliyun.com >/dev/null 2>&1
#         cat >/var/spool/cron/root <<EOF
#     10 0 * * * /usr/sbin/ntpdate ntp.aliyun.com > /dev/null 2>&1
#     * * * * */1 /usr/sbin/hwclock -w > /dev/null 2>&1
# EOF
    # fi
}
function Limits_Config() {

    sed -i "/^ulimit -SHn.*/d" /etc/rc.d/rc.local
    echo "ulimit -SHn 1024000" >>/etc/rc.d/rc.local

    sed -i "/^ulimit -s.*/d" /etc/profile
    sed -i "/^ulimit -c.*/d" /etc/profile
    sed -i "/^ulimit -SHn.*/d" /etc/profile

    cat >>/etc/profile <<EOF
ulimit -c unlimited
ulimit -s unlimited
ulimit -SHn 1024000
EOF

    source /etc/profile
    ulimit -a
    cat /etc/profile | grep ulimit

    if [ ! -f "/etc/security/limits.conf.bak" ]; then
        cp /etc/security/limits.conf /etc/security/limits.conf.bak
    fi

    cat >/etc/security/limits.conf <<EOF
* soft nofile 1024000
* hard nofile 1024000
* soft nproc  1024000
* hard nproc  1024000
hive   - nofile 1024000
hive   - nproc  1024000
EOF

    if [ ! -f "/etc/security/limits.d/20-nproc.conf.bak" ]; then
        cp /etc/security/limits.d/20-nproc.conf /etc/security/limits.d/20-nproc.conf.bak
    fi

    cat >/etc/security/limits.d/20-nproc.conf <<EOF
*          soft    nproc     409600
root       soft    nproc     unlimited
EOF
}

LANG_config() {
    echo "LANG=\"en_US.UTF-8\"" >/etc/locale.conf
    source /etc/locale.conf
}


function Err_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"false\",
	\"reason\":\"$1\"
}"
    exit 1
}

function Success_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"true\",
	\"reason\":\"\"
}"
    exit 0
}
function Require_Soft() {
    which $1 >/dev/null && echo "True" || echo "False"
}
Status=0
if [ "$(Require_Soft "firewall-cmd")" == "True" ]; then
    # 红帽系列
    systemctl stop firewalld && systemctl disable firewalld
else
    # Ubuntu系列
     /usr/sbin/ufw disable
fi


Close_Selinux
update_hosts_file
Change_Time
Limits_Config
LANG_config
Success_Exit