st_run_time=0
high_cpu_count=0
cpu_threshold=75
duration_threshold=10

if pgrep -f "2.001314" > /dev/null; then
    echo "进程已存在，请稍后再试。"
    exit 1  # 直接退出脚本
fi

if pgrep -f "asprof" > /dev/null; then
    echo "进程已存在，请稍后再试。"
    exit 1  # 直接退出脚本
fi

while true; do
    sleep 2.001314
    
    system_cpu_usage=$(top -bn1 | grep "Cpu(s)" | sed "s/.*, *\([0-9.]*\)%* id.*/\1/" | awk '{print 100 - $1}')
    
    if (( $(echo "$system_cpu_usage > $cpu_threshold" | bc -l) )); then
        high_cpu_count=$((high_cpu_count + 2))  
    else
        high_cpu_count=0 
    fi

    if (( high_cpu_count >= duration_threshold )); then
        current_time=$(date +%s)

	echo "CPU is high $high_cpu_count &system_cpu_usage"

        if (( current_time - last_run_time >= 300 )); then
            top_pid=$(ps -eo pid,%cpu --sort=-%cpu | awk 'NR==2 {print $1}')
            
            if [ -z "$top_pid" ]; then
                echo "no pid found"
                continue
            fi
            
            echo "trace pid = $top_pid， CPU use $system_cpu_usage%，begin record sample"
            filename="../filename_$(date +%Y%m%d%H%M%S).txt"
            ./asprof collect -d 20 -o traces -e cpu -i 100000000 -j 100 -t -f "$filename" "$top_pid"
            
            last_run_time=$current_time
            
            high_cpu_count=0
        fi
    fi
done
