#!/bin/bash
#---------------------------------------------------------------------------
# File: CheckFirewall.sh
# Created Date: 2022-04-01
# Author: sunzhe
# Contact: <sunzhenet@163.com>
# Last Modified: Thursday July 14th 2022 2:57:17 pm
# Copyright (c) 2022 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
# 检查防火墙
export LANG=en_US.utf8
export LC_ALL=en_US.utf8
function Err_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"false\",
	\"reason\":\"$1\"
}"
    exit 1
}

function Success_Exit() {
    echo "###[emonitor]###"
    echo "{
	\"status\":\"true\",
	\"reason\":\"\"
}"
    exit 0
}
function Require_Soft() {
    which $1 >/dev/null && echo "True" || echo "False"
}
Status=0
if [ "$(Require_Soft "firewall-cmd")" == "True" ]; then
    # 红帽系列
    FirewallStatus=$(systemctl status firewalld | grep running | wc -l)
    if [ "$FirewallStatus" -gt 0 ]; then
        systemctl stop firewalld && systemctl disable firewalld
        Status=$?
        
    fi
else
    # Ubuntu系列
    ufwStatus=$(/usr/sbin/ufw status | awk -F ":" '{print $2}' | tr -d " ")
    if [ "$ufwStatus" == "active" ]; then
        /usr/sbin/ufw disable
        Status=$?
    fi
fi

if [ ! -z "$Status" -a  "$Status" -ne 0 ]; then
    Err_Exit "检测到防火墙开启,请关闭防火墙"
fi
Success_Exit