#!/bin/sh


# 获取1小时前的Unix时间戳
threshold=$(date -d '1 hour ago' +%s)

# 使用ps命令获取所有arthas-boot进程的信息，并使用grep和awk命令筛选启动时间超过1小时的进程
result=$(ps -eo pid,lstart,cmd | grep "arthas-boot" | grep -v grep | awk -v threshold="$threshold" '{if (mktime($4 " " $5 " " $6 " " $7 " " $8 " " $9) < threshold) print $0}')

# 提取PID并逐个终止进程
while read -r line; do
    pid=$(echo "$line" | awk '{print $1}')
    echo "终止进程 PID: $pid"
	kill "$pid"
done <<< "$result"








