#!/bin/bash
#---------------------------------------------------------------------------
# File: uninstall.sh
# Created Date: 2021-12-29
# Author: sunzhe
# Contact: <sunzhenet@163.com>
# 
# Last Modified: Thursday December 30th 2021 1:22:58 pm
# 
# Copyright (c) 2021 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
Usage () {                  #定义函数Usage，输出脚本使用方法
    echo "Usage like:"
    echo "sh uninstall.sh -d /opt/weaver "
    exit 2
}

if [ $# != 2 ];then
    Usage
    exit 1
fi

while getopts ":d:" opt
do
    case $opt in
        d)
        # echo "The ecology path is $OPTARG"
		if [ -d "$OPTARG" ];then
			oaPath=$OPTARG
		else
			echo "$OPTARG is not exist,the script exit,please check"
			# Usage
			exit 1
		fi
        ;;
        ?)
        echo "The Enter Path is error,the correct useage is sh uninstall.sh -d /opt/weaver"
        exit 1;;
    esac
done

function Uninstall () {
    for i in $(dir $oaPath); do
        if [ -f "$oaPath/$i/stop.sh" ];then
            echo "停止服务"$i""
            sh $oaPath/$i/stop.sh 
            echo "删除服务注册文件"
            rm -rf /etc/systemd/system/$i*.service && systemctl daemon-reload
            echo "删除目录"$i""
            rm -rf "$oaPath/$i"
        elif [ -f "$oaPath/$i/stop_redis.sh" ];then
            echo "停止服务"$i""
            sh $oaPath/$i/stop_sentinel.sh
            sh $oaPath/$i/stop_redis.sh
            echo "删除服务注册文件"
            rm -rf /etc/systemd/system/redis*.service && rm -rf /etc/systemd/system/sentinel*.service&& systemctl daemon-reload
            echo "删除目录"$i""
            rm -rf "$oaPath/$i"
        fi
    done
    # 静默删除mysql
    if [ -f /tmp/mysql/stop_mysql.sh ]; then
        echo "检测到mysql存在,停止mysql"
        cd /tmp/mysql && sh stop_mysql.sh
        echo "删除mysql目录"
        rm -rf /tmp/mysql
    fi
    # 静默删除其他服务配置文件
    rm -rf /usr/lib/systemd/system/rabbitmq-server.service
    rm -rf /usr/lib/systemd/system/zookeeper.service
    rm -rf /usr/lib/systemd/system/kafka_*.service
    rm -rf /usr/lib/systemd/system/skywalking-*.service
    rm -rf /etc/systemd/system/elasticsearch*.service
    rm -rf /etc/systemd/system/mongo*.service
    rm -rf /etc/systemd/system/mysql_3382.service
    systemctl daemon-reload
}
Uninstall