#!/bin/bash
#---------------------------------------------------------------------------
# File: genergateway.sh
# Created Date: 2024-03-04
# Author: sunzhe
# Contact: <sunzhenet@163.com>
# Last Modified: Tuesday March 5th 2024 9:25:33 pm
# Copyright (c) 2024 Weaver
# It is never too late to be what you might have been.
# Dec:
# -----
# HISTORY:
# Date      	 By	Comments
# ----------	---	----------------------------------------------------------
#---------------------------------------------------------------------------
#检测gateway运行参数并提取

date=$(date +%Y%m%d%H%M)
function Err_Exit() {
    echo "###[emonitor]###"
    echo "{
        \"status\":\"false\",
        \"reason\":\"$1\"
}"
    exit 1
}

function Success_Exit() {
    echo "###[emonitor]###"
    echo "{
        \"status\":\"true\",
        \"reason\":\"\"
}"
    exit 0
}

function changeArgs() {
    IsInstall=$(ps -ef | grep gateway | grep -v grep | grep $1 | grep regist.sh | wc -l)
    if [ $IsInstall -eq 0 ] || [ $IsInstall -gt 1 ]; then
        echo "未找到$1进程或gateway存在多进程,请手动处理！"
        return 0
    fi
    echo "开始更新 $1"
    InstallPath=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/gateway.jar/'){ print $i }}}' | awk -F/ '{for(i=1;i<NF;i++) printf "%s/", $i; printf "\n"}')

    echo "安装路径: $InstallPath"
    ServerPort=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/server.port/'){ print $i }}}' | awk -F '=' '{print $2}')
    echo "安装端口：$ServerPort"
    NacosAddr=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/nacos.discovery.server-addr/'){ print $i }}}' | awk -F '=' '{print $2}')
    echo "Nacos地址： $NacosAddr"

    NacosUser=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/registrycenter.username/'){ print $i }}}' | awk -F '=' '{print $2}')
    echo "Nacos用户： $NacosUser"

    NacosPasswd=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/registrycenter.password/'){ print $i }}}' | awk -F '=' '{print $2}')
    echo "Nacos密码： $NacosPasswd"

    NacosNameSpace=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/configcenter.namespace/'){ print $i }}}' | awk -F '=' '{print $2}')
    echo "Nacos命名空间： $NacosNameSpace"

    Xmx=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/Xmx/'){ print $i }}}' | tr -d '-'|tr -d 'D')
    Xms=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/Xms/'){ print $i }}}' | tr -d '-'|tr -d 'D')
    JAVA_HOME=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk '{print $8}')
    ConfigCenterGroup=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/configcenter.group/'){ print $i }}}' | awk -F '=' '{print $2}')
    RegisCenterGroup=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/registrycenter.group/'){ print $i }}}' | awk -F '=' '{print $2}')
    DeployType=$(ps -ef | grep gateway | grep -v grep | grep $1.jar | awk -F " " '{ for(i=1;i<=NF;i++) {if($i ~  '/weaver.deploy/'){ print $i }}}' | awk -F '=' '{print $2}')
    OtherArgs=""
    # 停止gateway服务 并备份
    if [ ! -z $NacosUser ]; then
        OtherArgs="-Dweaver.framework.registrycenter.username=$NacosUser -Dweaver.framework.registrycenter.password=$NacosPasswd  -Dweaver.framework.configcenter.username=$NacosUser -Dweaver.framework.configcenter.password=$NacosPasswd"
    fi
    if [ ! -z $NacosNameSpace ]; then
        OtherArgs="$OtherArgs -Dweaver.framework.configcenter.namespace=$NacosNameSpace -Dweaver.framework.registrycenter.namespace=$NacosNameSpace"
    fi
    if [ ! -z $ConfigCenterGroup ]; then
        OtherArgs="$OtherArgs -Dweaver.framework.configcenter.group=$ConfigCenterGroup"
    fi
    if [ ! -z $RegisCenterGroup ]; then
        OtherArgs="$OtherArgs -Dweaver.framework.registrycenter.group=$RegisCenterGroup"
    fi

    echo "重启中，请等待"
    cd $InstallPath &&  mv regist.sh regist.sh-$date
    cat >$InstallPath/regist.sh <<EOF
#!/bin/bash
ulimit -n 65535 2>&1 >/dev/null
JVM_MIDDLEWARE="-${Xms} -${Xmx} -Dlog.path=${InstallPath}logs -Djava.security.egd=file:/dev/./urandom -Dfile.encoding=UTF-8 -Dserver.port=${ServerPort} -Dspring.profiles.active=txproduction -Denv=txproduction -Dweaver.allinone=false -Dweaver.deploy=${DeployType} -noverify -Dspring.cloud.nacos.discovery.server-addr=${NacosAddr} -Dspring.cloud.nacos.config.server-addr=${NacosAddr} -Dweaver.framework.configcenter.type=nacos -Dweaver.framework.registrycenter.type=nacos ${OtherArgs}"
$JAVA_HOME  \$JVM_MIDDLEWARE -jar ${InstallPath}$1.jar >> $InstallPath$1.log 2>&1 >/dev/null
EOF
    chmod +x $InstallPath/regist.sh
    # bash start.sh
    
    echo "更新完成"
    
}
changeArgs "weaver-gateway"
changeArgs "weaver-open-gateway"
Success_Exit "更新完成"