#!/bin/bash

# 无交互版本 - 直接删除小于4KB的JAR文件（排除javax.inject-1.jar）
# 用法: ./clean_small_jars.sh /path/to/lib

if [ $# -ne 1 ]; then
    echo "错误: 需要提供lib路径作为参数"
    echo "用法: $0 /path/to/lib"
    exit 1
fi

LIB_PATH="$1"

if [ ! -d "$LIB_PATH" ]; then
    echo "错误: 路径 '$LIB_PATH' 不存在或不是一个目录"
    exit 1
fi

echo "正在清理 $LIB_PATH 下小于4KB的JAR文件（排除javax.inject-1.jar）..."
small_jars=$(find "$LIB_PATH" -name "*.jar" -type f -size -4k ! -name "javax.inject-1.jar")
count=$(echo "$small_jars" | grep -c "\.jar$" 2>/dev/null || echo "$small_jars" | wc -l)

if [ "$count" -eq 0 ]; then
    echo "未找到小于4KB的JAR文件（除javax.inject-1.jar外）"
    exit 0
fi

echo "找到 $count 个小于4KB的JAR文件，正在删除..."
echo "$small_jars"

# 直接删除
find "$LIB_PATH" -name "*.jar" -type f -size -4k ! -name "javax.inject-1.jar" -delete
echo "清理完成，已删除 $count 个文件（javax.inject-1.jar被排除在外）"
